//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LYRICS_DIALOG_HH
#define BMP_LYRICS_DIALOG_HH

#include <gtkmm/dialog.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/notebook.h>
#include <gtkmm/textview.h>
#include <libglademm/xml.h>

#include "bmp/base-types.hh"
#include "bmp/ui-types.hh"

#include "lyrics-v2.hh"
#include "lastfm.hh"
using namespace Bmp::LastFM; 
using namespace Bmp::LastFM::XMLRPC; 

namespace Bmp
{
  class TrackInfoView;
  class TrackDetails
    : public Gtk::Window
  {
    public:

      TrackDetails (BaseObjectType                       * obj,
                    Glib::RefPtr<Gnome::Glade::Xml> const& xml);
      static TrackDetails* create ();
      virtual ~TrackDetails ();

      void set_metadata (TrackMetadata const& metadata);

    private:

      void
      got_lyrics (std::string const& lyrics, bool have_em);

      void
      get_lyrics (bool forced = false);

      void
      got_artist (std::string const& metadata, guint code); 

      void
      get_artist ();

      LyricWiki::TextRequestRefP m_lyrics_request;
      LastFM::XMLRPC::ArtistMetadataRequestRefPtr m_artist_request;

      Gtk::Notebook       * m_notebook_artist;
      Gtk::Notebook       * m_notebook_lyrics;
      Bmp::TrackInfoView  * m_widget_trackinfo;
      Gtk::Label          * m_widget_label_artist;
      Gtk::Label          * m_widget_label_title;
      Gtk::Image          * m_widget_cover;
      Gtk::TextView       * m_widget_lyrics;
      Gtk::TextView       * m_widget_artist;
      TrackMetadata         m_metadata;

      Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

  }; //class TrackDetails
} //namespace Bmp 

#endif // !BMP_LYRICS_DIALOG_HH

