//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_MANAGE_VOLUME_HH 
#define BMP_DIALOG_MANAGE_VOLUME_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <gtkmm/cellrenderer.h>
#include <gtkmm/dialog.h>
#include <gtkmm/image.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <libglademm/xml.h>

#include "hal.hh"

namespace Bmp
{
    class VolumeManageDialog
      : public Gtk::Dialog
    {
      public:
        typedef sigc::signal<void, std::string const&> SignalRescan;
      private:
        SignalRescan signal_scan_path_;
      public:
        SignalRescan&
        signal_scan_path()
        {
          return signal_scan_path_;
        }

      public:

        VolumeManageDialog (BaseObjectType*                        obj,
                            Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        static VolumeManageDialog * create (Glib::RefPtr<Gnome::Glade::Xml> const& xml);
        virtual ~VolumeManageDialog () {}

        void go (HAL::Volume const& volume);

      private:

        Glib::RefPtr<Gnome::Glade::Xml> m_ref_xml;

        enum
        {
          L_VOLUME_UDI,
          L_DEVICE_UDI,
          L_MOUNT_PATH,
          L_DEVICEFILE,

          N_LABELS
        };

        class Paths
          : public Gtk::TreeModelColumnRecord
        { 
          public:
            Gtk::TreeModelColumn <std::string> path;
            Paths ()
            {
              add (path);
            }
        };
        Paths columns;

        Gtk::TreeView			                  * m_view_music_paths;
        Gtk::Label                          * m_label[N_LABELS];
        Glib::RefPtr<Gtk::ListStore>	        m_store;
        HAL::Volume                           m_volume;

        void  on_selection_changed ();
        void  cell_data_func (Gtk::CellRenderer * basecell, Gtk::TreeIter const& iter);
    };
}
#endif //!BMP_DIALOG_MANAGE_VOLUME_HH
