//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2007 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DIALOG_EXPORT_HH
#define BMP_DIALOG_EXPORT_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_HH

#include "widgets/ccwidgets.hh"

#include <glibmm/ustring.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/liststore.h>
#include <libglademm/xml.h>

#include "bmp/library-types.hh"
#include "audio/audio.hh"

#include "dialog-simple-progress.hh"
#include <string>
using namespace Glib;
using namespace std;

namespace Bmp
{
    class ExportDialog
      : public Gtk::Dialog
    {
      public:

        ExportDialog (BaseObjectType                 * obj,
                      RefPtr<Gnome::Glade::Xml> const& xml);
        static ExportDialog* create ();
        virtual ~ExportDialog () {}

        void run (TrackV & v);

      private:

        class Columns : public Gtk::TreeModelColumnRecord
        {
          public:
            Gtk::TreeModelColumn<ustring> desc;
            Gtk::TreeModelColumn<string>  extension;

            Columns ()
            {
              add (desc);
              add (extension);
            }
        };

        void  on_select_destination_folder ();
        void  on_container_treeview_cursor_changed ();
        void  on_export_audio_toggled ();
        void  on_export_playlist_toggled ();

        void  transcode_stream_eos ();
        void  transcode_stream_abort ();
        void  transcode_stream_error (ustring const& error);
        void  transcode_stream_position (int position, Audio::ProcessorFileTranscode* p, SimpleProgress* sp);

        void  response_check ();

        RefPtr<Gnome::Glade::Xml> m_ref_xml;
        RefPtr<Gtk::ListStore>    m_list_store_plugins;
        Gtk::TreeView*            m_tree_view_plugins;
        Gtk::Button*              m_button_browse;
        Gtk::FileChooserDialog*   m_file_browser;

        Gtk::Entry*         m_filename_entry;
        Gtk::Entry*         m_dest_path_entry;
        Gtk::CheckButton*   m_cb_export_playlist;
        Gtk::CheckButton*   m_cb_export_audio;
    
        Gtk::RadioButton*   m_rb_mp3;
        Gtk::RadioButton*   m_rb_ogg;
        Gtk::RadioButton*   m_rb_none;

        string         m_container;
        ustring        m_transcode_error;

        bool           m_transcode_stream_eos;
        bool           m_transcode_stream_error;
        bool           m_transcode_stream_abort;

        Columns        m_columns;
    };
}
#endif // !BMP_DIALOG_EXPORT_HH
