//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <glibmm.h>
#include <glibmm/i18n.h>

#include <iostream>

#include "src/util.hh"
#include "src/uri++.hh"
#include "src/network.hh"
#include "src/vfs.hh"
#include "src/minisoup.hh"

using namespace Glib;

namespace Bmp
{
  namespace VFS
  {
      class PluginTransportHTTP
        : public Bmp::VFS::PluginTransportBase
      {

        public:

          virtual bool	
          can_process (const Glib::ustring& uri)
          {
              Bmp::URI u (uri); 
              return (u.get_protocol () == Bmp::URI::PROTOCOL_HTTP); 
          }

          virtual void
          handle_read (Bmp::VFS::Handle& handle) throw (ProcessingError)
          {
            Bmp::URI u (handle.get_uri());
            if (!u.port) u.port = 80;

            Soup::RequestSyncRefP request = Soup::RequestSync::create (ustring (u));
            guint code = request->run ();
    
            if (code == 200)
            {
              std::string data = request->get_data (); 
              handle.set_buffer (reinterpret_cast<const unsigned char *>(data.c_str()), strlen (data.c_str())+1);
            }
          }

          virtual void
          handle_write  (const Bmp::VFS::Handle& handle) throw (ProcessingError)
          {
          }
      };
    }
}
  
extern "C" Bmp::VFS::PluginTransportBase* plugin_create ()
{
  return new Bmp::VFS::PluginTransportHTTP;
}

extern "C" void plugin_delete (Bmp::VFS::PluginTransportHTTP* p)
{
  delete p;
}
