#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>

#include <taglib/fileref.h>
// Plugin-specific include
#include "resolver.h"
#include "mp4file.h"
#include "mp4tag.h"

static void _plugin_init (void) __attribute__((constructor));

static void _plugin_init (void)
{
  TagLib::FileRef::addFileTypeResolver(new MP4FileTypeResolver);
}

extern "C" int  _plugin_has_accessors;
int  _plugin_has_accessors = 1;

#include "bmp/database-types.hh"
#include "bmp/library-types.hh"
#include "bmp/library-ops.hh"

extern "C" const char ** _mimetypes ()
{
  static const char * _types[] =
  {
    "audio/x-m4a",
    NULL
  };

  return _types;
}

using namespace Bmp;
using namespace TagLib;

extern "C" bool _set (std::string const& name, Track & track)
{
  TagLib::MP4::File opfile (name.c_str());

  if (!(opfile.isOpen() && opfile.isValid()))
    return false;

  if (!(opfile.open_for_writing()))
    return false;

  MP4::Tag *tag = opfile.getMP4Tag ();

  if (tag)
    {
      metadata_set_common (track, tag);

      if (track.mb_album_artist_sort_name)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Sortname",
                              track.mb_album_artist_sort_name.get().c_str());

      if (track.mb_track_id)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Track Id",
                              track.mb_track_id.get().c_str());

      if (track.mb_album_id)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Album Id",
                              track.mb_album_id.get().c_str());

      if (track.mb_artist_id)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Artist Id",
                              track.mb_artist_id.get().c_str());

      if (track.mb_album_artist_id)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Album Artist Id",
                              track.mb_album_artist_id.get().c_str());

      if (track.mb_album_artist_sort_name)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Album Artist Sortname",
                              track.mb_album_artist_sort_name.get().c_str());

      if (track.mb_album_artist)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Album Artist",
                              track.mb_album_artist.get().c_str());

      if (track.mb_release_date)
        opfile.SetMetadataFreeForm (
                              "MusicBrainz Album Release Date",
                              track.mb_release_date.get().c_str());

      if (track.asin)
        opfile.SetMetadataFreeForm (
                              "Amazon ASIN",
                              track.asin.get().c_str());

      if (track.puid)
        opfile.SetMetadataFreeForm (
                              "MusicIP PUID",
                              track.puid.get().c_str());
      opfile.save ();
      return true;
    }
  else
    {
      return false;
    }
}

extern "C" bool _get (TagLib::File * p, DB::Row & row)  
{
  using namespace TagLib;
  

  MP4::File * opfile;

  if (!(opfile = dynamic_cast<MP4::File*> (p)))
    return false;

  struct {

      AttributeId     datum;
      char          * id;

  } extra_tags_mp4[] = {

      { ATTRIBUTE_MB_ARTIST_SORTNAME,         "MusicBrainz Sortname"              },
      { ATTRIBUTE_MB_TRACK_ID,                "MusicBrainz Track Id"              },
      { ATTRIBUTE_MB_ALBUM_ID,                "MusicBrainz Album Id"              },
      { ATTRIBUTE_MB_ARTIST_ID,               "MusicBrainz Artist Id"             },
      { ATTRIBUTE_MB_ALBUM_ARTIST_ID,         "MusicBrainz Album Artist Id"       },
      { ATTRIBUTE_MB_ALBUM_ARTIST_SORTNAME,   "MusicBrainz Album Artist Sortname" },
      { ATTRIBUTE_MB_ALBUM_ARTIST,            "MusicBrainz Album Artist"          },
      { ATTRIBUTE_MB_RELEASE_DATE,            "MusicBrainz Album Release Date"    },
      { ATTRIBUTE_ASIN,                       "Amazon ASIN"                       },
      { ATTRIBUTE_MUSICIP_PUID,               "MusicIP PUID"                      },
  };

  for (unsigned int n = 0; n < G_N_ELEMENTS (extra_tags_mp4); ++n)
  {
    std::string value;
    if (opfile->GetMetadataFreeForm (extra_tags_mp4[n].id, value))
      row.insert (std::make_pair (get_attribute_info(extra_tags_mp4[n].datum).id, Glib::ustring (value)));
  }

  return true;
}
