//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_LIBRARY_TYPES_HH
#define BMP_LIBRARY_TYPES_HH

#include <glibmm.h>

#include <boost/optional.hpp>
#include <boost/format.hpp>
#include <boost/tuple/tuple.hpp>
#include <boost/tuple/tuple_comparison.hpp>

#include "base_types.hh"
#include "database_types.hh"

namespace TagLib
{
  class Tag;
  namespace ID3v2
  {
    class Tag;
  }
}

namespace Bmp
{
  namespace Library
  {
    enum DatumTags 
    {
      TS_DATUM_ID,
      TS_DATUM_DESC,  
      TS_DATUM_TABLE
    };

    enum DatumTag 
    {
      TAG_DATUM_ID,
      TAG_DATUM_ATTR_NAME,
      TAG_DATUM_ATTR_TYPE,
      TAG_DATUM_ATTR_PRECISE,
      TAG_DATUM_ATTR_V_BOOL,
      TAG_DATUM_ATTR_V_INT,
      TAG_DATUM_ATTR_V_REAL,
      TAG_DATUM_ATTR_V_STRING,
    };

    enum Datum
    {
      DATUM_LOCATION,
      DATUM_ARTIST,
      DATUM_ALBUM,
      DATUM_TITLE,
      DATUM_TRACK,
      DATUM_TIME,
      DATUM_GENRE,
      DATUM_COMMENT,
      DATUM_RATING,
      DATUM_DATE,
      DATUM_MTIME,
      DATUM_BITRATE,
      DATUM_SAMPLERATE,
      DATUM_COUNT,
      DATUM_PLAYDATE,
      DATUM_ASIN,

#ifdef HAVE_HAL

      DATUM_HAL_VOLUME_UDI,
      DATUM_HAL_DEVICE_UDI,
      DATUM_VOLUME_RELATIVE_PATH,
      DATUM_VOLUME_RELATIVE_BASE_DIR,

#endif //HAVE_HAL

      DATUM_MB_ALBUM_ARTIST,
      DATUM_MB_ALBUM_ARTIST_ID,
      DATUM_MB_ALBUM_ARTIST_SORTNAME,
      DATUM_MB_TRACK_ID,
      DATUM_MB_ALBUM_ID,
      DATUM_MB_ARTIST_ID,
      DATUM_MB_ARTIST_SORTNAME,
      DATUM_MB_RELEASE_DATE,
      DATUM_MUSICIP_PUID,

      DATUM_NEW_ITEM,
      DATUM_HASH,

      DATUM_LAST
    };
     
    class Album
    {
      public:

        typedef boost::tuple <  oustring,
                                oustring,
                                oustring,
                                oustring,
                                oustring,
                                oustring,
                                ouint,
                                ouint       > TR;

        oustring    artist;
        oustring    album;
        oustring    asin;
        oustring    release_id;
        oustring    artist_id;
        oustring    sortname;
        ouint       tracks;
        ouint       date;
        obool       new_item;

        std::string   key;
        TR            tpl;

        static std::string  create_key (Album const& a);
        static TR           create_tpl (Album const& a);

        Album (Bmp::DB::Row const& row);
        Album () {};
    };
    typedef std::vector< Album > AlbumV;

    bool
    operator== (Album const& a,
                Album const& b);

    bool
    operator<  (Album const& a,
                Album const& b);

    class Track
    {
      public:

#ifdef HAVE_HAL
        boost::optional <Glib::ustring>   volume_udi;
        boost::optional <Glib::ustring>   device_udi;
        boost::optional <Glib::ustring>   volume_relative_path;
#endif //HAVE_HAL

        boost::optional <Glib::ustring>   location;
        boost::optional <Glib::ustring>   artist;
        boost::optional <Glib::ustring>   album;
        boost::optional <Glib::ustring>   title;
        boost::optional <Glib::ustring>   genre;
        boost::optional <Glib::ustring>   comment;
        boost::optional <Glib::ustring>   asin;
        boost::optional <Glib::ustring>   puid;
        boost::optional <Glib::ustring>   mb_album_artist;
        boost::optional <Glib::ustring>   mb_album_artist_id;
        boost::optional <Glib::ustring>   mb_album_artist_sort_name;
        boost::optional <Glib::ustring>   mb_track_id;
        boost::optional <Glib::ustring>   mb_album_id;
        boost::optional <Glib::ustring>   mb_artist_id;
        boost::optional <Glib::ustring>   mb_artist_sort_name;
        boost::optional <Glib::ustring>   mb_release_date;
        boost::optional <Glib::ustring>   hash;

        boost::optional <uint64_t>      duration;
        boost::optional <uint64_t>      bitrate;
        boost::optional <uint64_t>      samplerate;

        boost::optional <uint64_t>      tracknumber;
        boost::optional <uint64_t>      date;

        boost::optional <uint64_t>      rating;
        boost::optional <uint64_t>      mtime;
        boost::optional <uint64_t>      count;

        boost::optional <uint64_t>      playdate;

        boost::optional <bool>          new_item;

#ifdef HAVE_HAL
        Track (Bmp::DB::Row const& row, bool use_hal = true);
#else
        Track (Bmp::DB::Row const& row);
#endif //HAVE_HAL

        Track () {};
    };
    typedef std::vector< Track > TrackV;

    class UTrack
    {
      public:

        boost::optional <Glib::ustring>   location_cur;
        boost::optional <Glib::ustring>   location_new;
        boost::optional <Glib::ustring>   artist;
        boost::optional <Glib::ustring>   album;
        boost::optional <Glib::ustring>   title;
        boost::optional <Glib::ustring>   genre;
        boost::optional <Glib::ustring>   comment;

        boost::optional <Glib::ustring>   asin;
        boost::optional <Glib::ustring>   puid;
        boost::optional <Glib::ustring>   hash;

        boost::optional <Glib::ustring>   mb_album_artist;
        boost::optional <Glib::ustring>   mb_album_artist_id;
        boost::optional <Glib::ustring>   mb_album_artist_sort_name;
        boost::optional <Glib::ustring>   mb_track_id;
        boost::optional <Glib::ustring>   mb_album_id;
        boost::optional <Glib::ustring>   mb_artist_id;
        boost::optional <Glib::ustring>   mb_artist_sort_name;
        boost::optional <Glib::ustring>   mb_release_date;

#ifdef HAVE_HAL
        boost::optional <Glib::ustring>   volume_udi;
        boost::optional <Glib::ustring>   device_udi;
        boost::optional <Glib::ustring>   volume_relative_path;
#endif //HAVE_HAL

        boost::optional <uint64_t>      tracknumber;
        boost::optional <uint64_t>      date;

        boost::optional <uint64_t>      rating;
        boost::optional <uint64_t>      mtime;
        boost::optional <uint64_t>      count;

        boost::optional <uint64_t>      playdate;

        boost::optional <bool>          new_item;

        UTrack () {}

        UTrack (Track const& track)
        {
          location_cur                = track.location;
          artist                      = track.artist;
          album                       = track.album;
          title                       = track.title;
          genre                       = track.genre;
          comment                     = track.comment;

          asin                        = track.asin;
          puid                        = track.puid;

#ifdef HAVE_HAL
          volume_udi                  = track.volume_udi;
          device_udi                  = track.device_udi;
          volume_relative_path        = track.volume_relative_path;
#endif //HAVE_HAL

          mb_album_artist             = track.mb_album_artist;
          mb_album_artist_id          = track.mb_album_artist_id;
          mb_album_artist_sort_name   = track.mb_album_artist_sort_name;

          mb_track_id                 = track.mb_track_id;
          mb_album_id                 = track.mb_album_id;

          mb_artist_id                = track.mb_artist_id;
          mb_artist_sort_name         = track.mb_artist_sort_name;

          tracknumber                 = track.tracknumber;
          date                        = track.date;

          rating                      = track.rating;
          mtime                       = track.mtime;
          count                       = track.count;
          playdate                    = track.playdate;

          new_item                    = track.new_item;
        }
    };

    typedef std::vector < UTrack > UTrackV;

    void metadata_set_common  (UTrack const& track, TagLib::Tag * tag);
    void metadata_get_id3v2   (TagLib::ID3v2::Tag * tag, DB::Row & row, std::string const& name);

  } // namespace Library

  std::string               MetadatumId     (Bmp::Library::Datum datum);
  DB::DatumDefine           MetadatumDefine (Bmp::Library::Datum datum);

} // namespace Bmp 

#endif // !BMP_LIBRARY_TYPES_HH
