/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2004-2005  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __A2DP_LIB_H__
#define __A2DP_LIB_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "../a2dp.h"
#include <stdio.h>
#include "a2dpd_protocol.h"
#include "a2dpd_ipc.h"

#define A2DPD_FLAGS_DISPLAYBANDWITH     1
#define A2DPD_FLAGS_DISPLAYSTATE        2
#define A2DPD_FLAGS_DISPLAYDRYSTREAM    4

// To send one L2CAP packets of 678 bytes, 4 ACL packets are sent, 3 are 192 bytes long, 
// 1 contains 49 bytes  => loss 192-49/4
// To send one L2CAP packets of 610 bytes, 3 ACL packets are sent, 2 are 192 bytes long, 
// 1 contains 165 bytes => loss 192-165/3

typedef struct snd_pcm_a2dp* LPA2DP;

// Global library initialisation
extern void a2dp_init( void);
extern void a2dp_exit( void);

// Connect to an a2dp provider
typedef struct
{
	char bdaddr[32];
	int framerate;
	int channels;
	int sbcbitpool;
	int flags;
} A2DPSETTINGS;

extern LPA2DP a2dp_new( A2DPSETTINGS* settings);
extern void a2dp_destroy( LPA2DP *a2dp);

int a2dp_state_use_socket(LPA2DP a2dp, int cmdfd);
int a2dp_state_connect(LPA2DP a2dp);
void a2dp_state_startstream(LPA2DP a2dp);
void a2dp_state_suspend(LPA2DP a2dp);
void a2dp_state_disconnect(LPA2DP a2dp);
int a2dp_is_streaming(LPA2DP a2dp);
int a2dp_is_connected(LPA2DP a2dp);
int a2dp_is_connecting(LPA2DP a2dp);
void a2dp_add_fd_to_poll(LPA2DP a2dp, struct pollinfo* pollinfos);
int a2dp_state_machine(LPA2DP a2dp);
void a2dp_set_dst_addr(LPA2DP a2dp, char* bdaddr);
void a2dp_set_user_flags(LPA2DP a2dp, int flags);
int a2dp_get_user_flags(LPA2DP a2dp);

// compress and transfers data
extern int a2dp_transfer_raw( LPA2DP a2dp, const char* pcm_buffer, int pcm_buffer_size, AUDIOPACKETHEADER* lpHdr);
extern int a2dp_reset_encoding_buffer(LPA2DP a2dp);

// a2dp server functions
int a2dp_make_listen_socket( unsigned short psm);
int a2dp_wait_connection( int sockfd, char* szRemote, int iRemoteSize, uint16_t *mtu);

#endif
