# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gobject import markup_escape_text as escape
from gtk.gdk import pixbuf_new_from_file, INTERP_BILINEAR
from gtk import STOCK_DIALOG_INFO
from os.path import isfile, join

try:
    from pynotify import init as pynotify_init, URGENCY_LOW, Notification
    pynotify_imported = True
except ImportError:
    pynotify_imported = False

from common.functions import Functions
functions = Functions()
hlength = functions.human_length

class Notify:
    def __init__(self, config):
        self.config = config

        # pynotify is an optional depends
        if not pynotify_imported:
            self.is_activated = False
            print '[Notify plugin] You need python-notify.'
            return

        # Start pynotify
        self.notif = None
        self.tray = None
        pynotify_init('bluemindo')

        # Fake stopped if plugin is desactivated during execution
        self.is_activated = True

    def _reload_conf(self, newconf):
        """Reload the configuration of the plugin."""
        del self.config
        self.config = newconf

    def _stop_plugin(self):
        """Fake the unload of the plugin."""
        self.is_activated = False

    def _create_notification(self, title, text, icon):
        """Create or update a notification and show it."""

        # Quit if plugin has been desactivated
        if not self.is_activated:
            return

        if self.notif:
            if icon:
                self.notif.update(title, text)
            else:
                self.notif.update(title, text, STOCK_DIALOG_INFO)
        else:
            if icon:
                self.notif = Notification(title, text, None)
            else:
                self.notif = Notification(title, text, STOCK_DIALOG_INFO)

            if self.tray is not None:
                try:
                    self.notif.attach_to_widget(self.tray)
                except TypeError:
                    self.notif.attach_to_status_icon(self.tray)

            self.notif.set_urgency(URGENCY_LOW)
            self.notif.set_timeout(self.config['timeout'])

        if icon:
            self.notif.set_icon_from_pixbuf(icon)

        self.notif.show()

    def _get_tray(self, tray):
        """Get the trayicon."""
        self.tray = tray

    def load_new_song(self, song):
        """Handler for a new playing song."""
        title = song[0]
        artist = song[1]
        album = song[2]
        comment = song[3]
        genre = song[4]
        year = song[5]
        track = song[6]
        length = song[7]

        def parse(string):
            string = string.replace('{title}', title)
            string = string.replace('{artist}', escape(artist))
            string = string.replace('{album}', escape(album))
            string = string.replace('{comment}', escape(comment))
            string = string.replace('{genre}', escape(genre))
            string = string.replace('{year}', str(year))
            string = string.replace('{track}', str(track))
            string = string.replace('{length}', hlength(length))

            return string

        album_file = join(self.config['__player-data'], 'covers',
                          functions.get_hash(album, artist))

        if isfile(album_file):
            icon = pixbuf_new_from_file(album_file)
            icon = icon.scale_simple(50, 50, INTERP_BILINEAR)
        else:
            icon = None

        notif_title = parse(self.config['title'])
        notif_text = parse(self.config['text'])

        self._create_notification(notif_title, notif_text, icon)

    def show(self):
        """Force notification."""
        if self.notif is not None:
            self.notif.show()