# -*- coding: utf-8 -*-

#  Bluemindo
#  editsong.py

#    Bluemindo: A really simple but powerful audio player in Python/PyGTK.
#    Copyright (C) 2007-2008  Erwan Briand

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation version 3 of the License.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk import (MessageDialog, DIALOG_MODAL, MESSAGE_INFO, BUTTONS_OK,
                 WIN_POS_CENTER_ALWAYS)
from gtk.glade import XML as glade_XML
import tagpy

from common.sqlite import SQLite
from common.functions import Functions

functions = Functions()

class EditSong:
    def __init__(self, glade, gst):
        cur = gst.nowplaying

        if not cur == None:
            # tagpy initialization
            try:
                self.filetag = tagpy.FileRef(cur)
                tag_retrieve = True
            except:
                tag_retrieve = False
            
            if tag_retrieve:
                self.tags = self.filetag.tag()

            # Start the GUI
            xml = glade_XML(functions.datadir + '/glade/editsongwindow.glade',
                                                'window1', domain='bluemindo')
            window = xml.get_widget('window1')
            window.set_position(WIN_POS_CENTER_ALWAYS)
            window.set_title(_('Edit a song - Bluemindo'))
        
            xml.get_widget('label2').set_alignment(0, 0.5)
            xml.get_widget('label4').set_alignment(0, 0.5)
            xml.get_widget('label5').set_alignment(0, 0.5)
            xml.get_widget('label6').set_alignment(0, 0.5)
            xml.get_widget('label8').set_alignment(0, 0.5)

            xml.get_widget('entry1').set_text(self.tags.title)
            xml.get_widget('entry2').set_text(self.tags.artist)
            xml.get_widget('entry3').set_text(self.tags.album)
            xml.get_widget('entry6').set_text(self.tags.genre)
            xml.get_widget('entry4').set_text(cur)
            xml.get_widget('spinbutton1').set_value(self.tags.track)

            # GTK handlers
            xml.get_widget('button-validate').connect(
                           'clicked', self.valid_song, xml, cur,
                           (xml.get_widget('entry1'), xml.get_widget('entry2'),
                            xml.get_widget('entry3'), xml.get_widget('entry6'),
                            xml.get_widget('spinbutton1')
                           ))
            xml.get_widget('button-cancel').connect('clicked', self.quit, xml)

    def valid_song(self, widget, gld, cr, (title, artist, album, genre, track)):
        # Write edited tags
        gld.get_widget('window1').destroy()

        self.tags.title = title.get_text()
        self.tags.artist = artist.get_text()
        self.tags.album = album.get_text()
        self.tags.genre = genre.get_text()
        self.tags.track = int(track.get_value())

        self.filetag.save()

        sqlite = SQLite()
        sqlite.execute('update songs set title ="%(title)s", '
                       'artist ="%(artist)s", album ="%(album)s", '
                       'genre ="%(genre)s", track ="%(track)s" where '
                       'filename ="(%(filename)s"' %
                       {'title': self.tags.title,
                        'artist': self.tags.artist,
                        'album': self.tags.album,
                        'genre': self.tags.genre,
                        'track': self.tags.track,
                        'filename': cr
                       })
        sqlite.close()

        msgbox = MessageDialog(None, DIALOG_MODAL, MESSAGE_INFO, BUTTONS_OK,
                               _('Audio tags written and database uploaded!'))
        msgbox.set_title(_('Information.'))
        msgbox.run()
        msgbox.destroy()

    def quit(self, widget, glade):
        glade.get_widget('window1').destroy()
