#!/usr/bin/env python

# BloGTK Version 1.0
# Custom Tags Routines - customtags.py
# (C)2004 Jay Reding
# Code released under the terms of the BSD License. (See file LICENSE)

# This function library contains the function for managing BloGTK's library of 
# custom tags.

import pygtk
import gtk
import gtk.glade
import pango
import ConfigParser
import os

foo = 0

def displayTagsWindow(mainGlade):

   # 0.6 - Let's pull the controls we'll need for this form.
   tagsWindow = mainGlade.get_widget("tagsWindow")
   tagsCombo = mainGlade.get_widget("tagsCombo")
   tagsEntry = mainGlade.get_widget("tagsEntry")
   tagsOKButton = mainGlade.get_widget("tagsOKButton")
   tagAddButton = mainGlade.get_widget("tagAddButton")
   delTagButton = mainGlade.get_widget("delTagButton")

   tagsWindow.show()

   # 0.6 - When the user selects a new tag, we need to repopulate our entries
   tagsCombo.entry.connect("changed", populateWindow, foo, mainGlade)

   # 0.6 - Let's populate our combo box of custom tags from the tags.conf file.
   confDir = os.path.expanduser('~') + "/.BloGTK"
   conf_file = confDir + "/tags.conf"
   config = ConfigParser.ConfigParser()
   config.readfp(open(conf_file))
   tags = config.sections()
   tagsCombo.set_popdown_strings(tags)

   # 0.6 - We should set our callbacks sometime. Now seems good.
   tagAddButton.connect_object("clicked", addTag, mainGlade)
   delTagButton.connect_object("clicked", delTag, mainGlade)

   tagsWindow.connect_object("delete_event", windowHider, tagsWindow)
   tagsOKButton.connect_object("clicked", windowHider, tagsWindow, foo)

def windowHider(widget, foo):
   # Strike me down, and I'll become invisible like Obi-Wan did...
   widget.hide()
   return gtk.TRUE

def populateWindow(widget, foo, mainGlade):
   tagsEntry = mainGlade.get_widget("tagsEntry")
   tagNameEntry = mainGlade.get_widget("tagNameEntry")
   startTagEntry = mainGlade.get_widget("startTagEntry")
   scriptEntry = mainGlade.get_widget("scriptEntry")
   endTagEntry = mainGlade.get_widget("endTagEntry")

   confDir = os.path.expanduser('~') + "/.BloGTK"
   conf_file = confDir + "/tags.conf"
   config = ConfigParser.ConfigParser()
   config.readfp(open(conf_file))

   tag_name = tagsEntry.get_text()

   tagNameEntry.set_text(tag_name)

   # 0.6 - For some reason, Python throws a NoSectionError with this code, despite the fact that
   # there's no error. For convenience's sake, we'll escape this error for now.

   try:
      start_tag = config.get(tagsEntry.get_text(), "start_tag")
      startTagEntry.set_text(start_tag)
   except ConfigParser.NoSectionError:
      pass

   try:
      script_tag = config.get(tagsEntry.get_text(), "script_tag")
      scriptEntry.set_text(script_tag)
   except ConfigParser.NoSectionError:
      pass

   try:
      end_tag = config.get(tagsEntry.get_text(), "end_tag")
      endTagEntry.set_text(end_tag)
   except ConfigParser.NoSectionError:
      pass

def addTag(mainGlade):

   tagsEntry = mainGlade.get_widget("tagsEntry")
   tagNameEntry = mainGlade.get_widget("tagNameEntry")
   startTagEntry = mainGlade.get_widget("startTagEntry")
   scriptEntry = mainGlade.get_widget("scriptEntry")
   endTagEntry = mainGlade.get_widget("endTagEntry")

   # 0.6 - This function allows us to add new custom tags and edit previous ones.
   tag_name = tagNameEntry.get_text()
   start_tag = startTagEntry.get_text()
   script_tag = scriptEntry.get_text()
   end_tag = endTagEntry.get_text()

   exists = 0

   confDir = os.path.expanduser('~') + "/.BloGTK"
   conf_file = confDir + "/tags.conf"
   config = ConfigParser.ConfigParser()
   config.readfp(open(conf_file))

   tags = config.sections()

   for item in tags:
      if item == tag_name:
         exists = 1
      else:
         pass

   if exists == 0:
      config.add_section(tag_name)
      config.set(tag_name, "start_tag", start_tag)
      config.set(tag_name, "script_tag", script_tag)
      config.set(tag_name, "end_tag", end_tag)
      saveFile = open(conf_file, "w")
      config.write(saveFile)
      saveFile.close()
      refresh(mainGlade)
   else:
      config.set(tag_name, "start_tag", start_tag)
      config.set(tag_name, "script_tag", script_tag)
      config.set(tag_name, "end_tag", end_tag)
      saveFile = open(conf_file, "w")
      config.write(saveFile)
      saveFile.close()
      refresh(mainGlade)

def delTag(mainGlade):

   # 0.6 - Here is where we delete our custom tags.
   tagNameEntry = mainGlade.get_widget("tagNameEntry")
   tag_name = tagNameEntry.get_text()

   confDir = os.path.expanduser('~') + "/.BloGTK"
   conf_file = confDir + "/tags.conf"
   config = ConfigParser.ConfigParser()
   config.readfp(open(conf_file))

   config.remove_option(tag_name, "start_tag")
   config.remove_option(tag_name, "script_tag")
   config.remove_option(tag_name, "end_tag")
   config.remove_section(tag_name)

   saveFile = open(conf_file, "w")
   config.write(saveFile)
   saveFile.close()
   refresh(mainGlade)

def refresh(mainGlade):

   # 0.6 - Here's where we refresh our tag list.
   tagsCombo = mainGlade.get_widget("tagsCombo")

   confDir = os.path.expanduser('~') + "/.BloGTK"
   conf_file = confDir + "/tags.conf"
   config = ConfigParser.ConfigParser()
   config.readfp(open(conf_file))
   tags = config.sections()
   tagsCombo.set_popdown_strings(tags)

   # 0.6 - We also need to refresh the tags list in the main window.
   mainTagCombo = mainGlade.get_widget("mainTagCombo")
   mainTagCombo.set_popdown_strings(tags)
