/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "translation.h"

/*
Translate everything in the level that requires a translation...
*/
void translateAll()
{
	engine.getLocaleInformation(map.name);
	
	Objective *objective = (Objective*)map.objectiveList.getHead();

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		strcpy(objective->description, engine.translate(objective->description));
	}

	Switch *swt = (Switch*)map.switchList.getHead();

	while (swt->next != NULL)
	{
		swt = (Switch*)swt->next;
		strcpy(swt->activateMessage,  engine.translate(swt->activateMessage));
	}

	LineDef *lineDef = (LineDef*)map.lineList.getHead();

	while (lineDef->next != NULL)
	{
		lineDef = (LineDef*)lineDef->next;
		strcpy(lineDef->activateMessage,  engine.translate(lineDef->activateMessage));
	}
}
