/**
 * blenlib/BKE_image.h (mar-2001 nzc)
 *	
 * $Id: BKE_image.h,v 1.16 2006/12/20 17:57:41 ton Exp $ 
 *
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
 */
#ifndef BKE_IMAGE_H
#define BKE_IMAGE_H

#ifdef __cplusplus
extern "C" {
#endif

struct Image;
struct ImBuf;
struct Tex;
struct anim;

/* call from library */
void	free_image(struct Image *me);

int		BKE_write_ibuf(struct ImBuf *ibuf, char *name, int imtype, int subimtype, int quality);
void	BKE_makepicstring(char *string, char *base, int frame, int imtype);
void	BKE_add_image_extension(char *string, int imtype);
int		BKE_ftype_to_imtype(int ftype);
int		BKE_imtype_to_ftype(int imtype);
int		BKE_imtype_is_movie(int imtype);

struct anim *openanim(char * name, int flags);

void	converttopremul(struct ImBuf *ibuf);
void	image_de_interlace(struct Image *ima, int odd);
	
void	tag_image_time(struct Image *ima);
void	free_old_images(void);

/* ********************************** NEW IMAGE API *********************** */

/* ImageUser is in Texture, in Nodes, Background Image, Image Window, .... */
/* should be used in conjunction with an ID * to Image. */
struct ImageUser;
struct RenderPass;
struct RenderResult;

/* ima->source; where image comes from */
#define IMA_SRC_CHECK		0
#define IMA_SRC_FILE		1
#define IMA_SRC_SEQUENCE	2
#define IMA_SRC_MOVIE		3
#define IMA_SRC_GENERATED	4
#define IMA_SRC_VIEWER		5

/* ima->type, how to handle/generate it */
#define IMA_TYPE_IMAGE		0
#define IMA_TYPE_MULTILAYER	1
		/* generated */
#define IMA_TYPE_UV_TEST	2
#define IMA_TYPE_VERSE		3
		/* viewers */
#define IMA_TYPE_R_RESULT   4
#define IMA_TYPE_COMPOSITE	5

/* ima->ok */
#define IMA_OK				1
#define IMA_OK_LOADED		2

/* signals */
	/* reload only frees, doesn't read until image_get_ibuf() called */
#define IMA_SIGNAL_RELOAD			0
#define IMA_SIGNAL_FREE				1
	/* pack signals are executed */
#define IMA_SIGNAL_PACK				2
#define IMA_SIGNAL_REPACK			3
#define IMA_SIGNAL_UNPACK			4
	/* source changes, from image to sequence or movie, etc */
#define IMA_SIGNAL_SRC_CHANGE		5
	/* image-user gets a new image, check settings */
#define IMA_SIGNAL_USER_NEW_IMAGE	6

/* depending Image type, and (optional) ImageUser setting it returns ibuf */
/* always call to make signals work */
struct ImBuf *BKE_image_get_ibuf(struct Image *ima, struct ImageUser *iuser);

/* returns existing Image when filename/type is same */
struct Image *BKE_add_image_file(const char *name);

/* adds image, adds ibuf, generates color or pattern */
struct Image *BKE_add_image_size(int width, int height, char *name, short uvtestgrid);

/* for reload, refresh, pack */
void BKE_image_signal(struct Image *ima, struct ImageUser *iuser, int signal);

/* ensures an Image exists for viewing nodes or render */
struct Image *BKE_image_verify_viewer(int type, const char *name);

/* force an ImBuf to become part of Image */
void BKE_image_assign_ibuf(struct Image *ima, struct ImBuf *ibuf);

/* called on frame change or before render */
void BKE_image_user_calc_imanr(struct ImageUser *iuser, int cfra, int fieldnr);

/* fix things in ImageUser when new image gets assigned */
void BKE_image_user_new_image(struct Image *ima, struct ImageUser *iuser);

/* sets index offset for multilayer files */
struct RenderPass *BKE_image_multilayer_index(struct RenderResult *rr, struct ImageUser *iuser);

/* for multilayer images as well as for render-viewer */
struct RenderResult *BKE_image_get_renderresult(struct Image *ima);

/* goes over all textures that use images */
void	BKE_image_free_all_textures(void);

/* does one image! */
void	BKE_image_free_anim_ibufs(struct Image *ima, int except_frame);

/* does all images with type MOVIE or SEQUENCE */
void BKE_image_all_free_anim_ibufs(int except_frame);

void BKE_image_memorypack(struct Image *ima);

#ifdef __cplusplus
}
#endif

#endif

