/**
 * $Id: KX_BlenderPolyMaterial.cpp,v 1.4 2004/03/22 22:01:23 jesterking Exp $
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
 */

#include "KX_BlenderPolyMaterial.h"
#include "BKE_mesh.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KX_BlenderPolyMaterial::KX_BlenderPolyMaterial(const STR_String &texname,
											   bool ba,
											   const STR_String& matname,
											   int tile,
											   int tilexrep,
											   int tileyrep,
											   int mode,
											   int transparant,
											   int lightlayer,
											   bool bIsTriangle,
											   void* clientobject,
											   struct TFace* tface)
		: RAS_IPolyMaterial(texname,
							false,
							matname,
							tile,
							tilexrep,
							tileyrep,
							mode,
							transparant,
							lightlayer,
							bIsTriangle,
							clientobject),
		m_tface(tface)
{
}


void KX_BlenderPolyMaterial::Activate(RAS_IRasterizer* rasty, TCachingInfo& cachingInfo) const 
{

	
	if (GetCachingInfo() != cachingInfo)
	{
		if (!cachingInfo)
		{
			set_tpage(NULL);
		}
		cachingInfo = GetCachingInfo();

		if ((m_drawingmode & 4)&& (rasty->GetDrawingMode() == RAS_IRasterizer::KX_TEXTURED))
		{
			update_realtime_texture((struct TFace*) m_tface, rasty->GetTime());
			set_tpage(m_tface);
			rasty->EnableTextures(true);
		}
		else
		{
			set_tpage(NULL);
			rasty->EnableTextures(false);
		}
		
		if(m_drawingmode & RAS_IRasterizer::KX_TWOSIDE)
		{
			rasty->SetCullFace(false);
		}
		else
		{
			rasty->SetCullFace(true);
		}

		if (m_drawingmode & RAS_IRasterizer::KX_LINES) {
			rasty->SetLines(true);
		}
		else {
			rasty->SetLines(false);
		}
	}

	rasty->SetSpecularity(m_specular[0],m_specular[1],m_specular[2],m_specularity);
	rasty->SetShinyness(m_shininess);
	rasty->SetDiffuse(m_diffuse[0], m_diffuse[1],m_diffuse[2], 1.0);
}




