//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
//

using Gtk;
using System;

namespace Imendio.Blam {
    public class TrayIcon {
    private Gtk.StatusIcon mIcon = null;

	public event EventHandler ButtonPressEvent;

	public string Tooltip {
	    set {
		    mIcon.Tooltip = value;
	    }
	}

	public TrayIcon (string name)
	{
        mIcon = new Gtk.StatusIcon();
        mIcon.IconName = "blam";
        mIcon.Tooltip = name;
        mIcon.Activate += ButtonPressedCb;
	}
	
    public void Hide()
    {
        mIcon.Visible = false;
    }

	public void Show ()
	{
	    mIcon.Visible = true;
	}

	private void ButtonPressedCb (object o, EventArgs args)
	{
	    if (this.ButtonPressEvent != null) {
		this.ButtonPressEvent (o, args);
	    }
	}

    }
}
