//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2005 Imendio AB
// (C) 2005 Michael Ostermeier

using System.IO;

namespace Imendio.Blam {
	public class Theme {
		private string mName = "";
		private string mPath = "";

	    private static readonly string mAuthor  = "${author}";
		private static readonly string mLink    = "${link}";
		private static readonly string mPubdate = "${pubdate}";
		private static readonly string mText    = "${text}";
		private static readonly string mUrl     = "${url}";
		private static readonly string mTitle   = "${title}";

		private string mThemeHtml = "";

		public Theme (string path)
		{
			mPath = path;

            Load ();
		}

		public string Name {
			get {
				return mName;
			}
		}

		public string Path {
			get {
				return mPath;
			}
		}

		public string Render(string author, string link, string pubdate,
                             string text, string title, string url) 
		{
			return mThemeHtml.Replace(mAuthor, author)
							 .Replace(mLink, link)
							 .Replace(mPubdate, pubdate)
							 .Replace(mText, text)
							 .Replace(mTitle, title)
							 .Replace(mUrl, url);
		}

		private void Load () 
		{
            string fileName = mPath + "/" + Defines.THEME_INDEX_NAME;
            TextReader r = File.OpenText (fileName);
            mThemeHtml = r.ReadToEnd ();
            r.Close ();

            // TODO: Add better error handling here
            mName = mPath.Substring (mPath.LastIndexOf ("/") + 1);
		}
	}
}
