/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.ColorIconResource;
import com.kreative.rsrc.IconListResource;
import com.kreative.rsrc.IconResource;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceProvider;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuShortcut;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1296387669;
    public static final int RESOURCE_TYPE_SHORT_CMD = 1668116085;
    public static final int RESOURCE_TYPE_LONG_CMD = 1129139797;
    public int commandIDLength = 0;

    public static boolean isMyType(int type) {
        return type == 1296387669 || type == 1668116085 || type == 1129139797;
    }

    public MenuResource(short id, byte[] data) {
        super(1296387669, id, data);
        this.autoLength();
    }

    public MenuResource(short id, String name, byte[] data) {
        super(1296387669, id, name, data);
        this.autoLength();
    }

    public MenuResource(short id, byte attr, byte[] data) {
        super(1296387669, id, attr, data);
        this.autoLength();
    }

    public MenuResource(short id, byte attr, String name, byte[] data) {
        super(1296387669, id, attr, name, data);
        this.autoLength();
    }

    public MenuResource(int type, short id, byte[] data) {
        super(type, id, data);
        this.autoLength();
    }

    public MenuResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
        this.autoLength();
    }

    public MenuResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
        this.autoLength();
    }

    public MenuResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
        this.autoLength();
    }

    public void autoLength() {
        switch (this.type) {
            case 1296387669: {
                this.commandIDLength = 0;
                break;
            }
            case 1668116085: {
                this.commandIDLength = 2;
                break;
            }
            case 1129139797: {
                this.commandIDLength = 4;
            }
        }
    }

    public short getMenuID() {
        return KSFLUtilities.getShort(this.data, 0);
    }

    public short getWidth() {
        return KSFLUtilities.getShort(this.data, 2);
    }

    public short getHeight() {
        return KSFLUtilities.getShort(this.data, 4);
    }

    public Dimension getSize() {
        return new Dimension(KSFLUtilities.getShort(this.data, 2), KSFLUtilities.getShort(this.data, 4));
    }

    public short getProcID() {
        return KSFLUtilities.getShort(this.data, 6);
    }

    public int getEnableBits() {
        return KSFLUtilities.getInt(this.data, 10);
    }

    public boolean getEnabled() {
        return (KSFLUtilities.getInt(this.data, 10) & 1) != 0;
    }

    public boolean getEnabled(int index) {
        if (++index < 0) {
            index = 0;
        } else if (index >= 32) {
            index = 31;
        }
        return (KSFLUtilities.getInt(this.data, 10) & 1 << index) != 0;
    }

    public String getTitle() {
        String s;
        try {
            s = KSFLUtilities.getPString(this.data, 14, "MACROMAN");
        }
        catch (UnsupportedEncodingException uue) {
            s = KSFLUtilities.getPString(this.data, 14);
        }
        if (s.equals("\u0014")) {
            s = "\uf8ff";
        }
        return s;
    }

    public Iterator<MenuItem> iterator() {
        return new Iterator<MenuItem>(){
            private int p;
            private int idx;
            {
                this.p = 14 + ((MenuResource.this.data[14] & 0xFF) + 1);
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.p < MenuResource.this.data.length && MenuResource.this.data[this.p] != 0;
            }

            @Override
            public MenuItem next() {
                MenuItem mi = new MenuItem();
                mi.enabled = MenuResource.this.getEnabled(this.idx);
                ++this.idx;
                mi.menuItemName = KSFLUtilities.getPString(MenuResource.this.data, this.p);
                this.p += (MenuResource.this.data[this.p] & 0xFF) + 1;
                mi.iconID = MenuResource.this.data[this.p] == 0 ? (short)0 : (short)(256 + (MenuResource.this.data[this.p] & 0xFF));
                ++this.p;
                try {
                    mi.commandChar = new String(new byte[]{MenuResource.this.data[this.p]}, "MACROMAN").charAt(0);
                }
                catch (UnsupportedEncodingException uee) {
                    mi.commandChar = new String(new byte[]{MenuResource.this.data[this.p]}).charAt(0);
                }
                ++this.p;
                try {
                    mi.markChar = new String(new byte[]{MenuResource.this.data[this.p]}, "MACROMAN").charAt(0);
                }
                catch (UnsupportedEncodingException uee) {
                    mi.markChar = new String(new byte[]{MenuResource.this.data[this.p]}).charAt(0);
                }
                mi.submenuID = (short)(MenuResource.this.data[this.p] & 0xFF);
                ++this.p;
                mi.style = MenuResource.this.data[this.p];
                ++this.p;
                switch (MenuResource.this.commandIDLength) {
                    case 1: {
                        mi.commandNumber = MenuResource.this.data[this.p];
                        ++this.p;
                        break;
                    }
                    case 2: {
                        if ((this.p & 1) == 1) {
                            ++this.p;
                        }
                        mi.commandNumber = KSFLUtilities.getShort(MenuResource.this.data, this.p);
                        this.p += 2;
                        break;
                    }
                    case 4: {
                        if ((this.p & 1) == 1) {
                            ++this.p;
                        }
                        mi.commandNumber = KSFLUtilities.getInt(MenuResource.this.data, this.p);
                        this.p += 4;
                    }
                }
                mi.fixChars();
                return mi;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Menu makeMenu(MacResourceProvider rp) {
        Menu m = new Menu(this.getTitle());
        Iterator<MenuItem> i = this.iterator();
        while (i.hasNext()) {
            m.add(i.next().makeMenuItem(rp));
        }
        m.setEnabled(this.getEnabled());
        return m;
    }

    public JMenu makeJMenu(MacResourceProvider rp) {
        JMenu m = new JMenu(this.getTitle());
        Iterator<MenuItem> i = this.iterator();
        while (i.hasNext()) {
            m.add(i.next().makeJMenuItem(rp));
        }
        m.setEnabled(this.getEnabled());
        return m;
    }

    public static class MenuItem {
        public static final char COMMANDCHAR_SUBMENU = '\u001b';
        public static final char COMMANDCHAR_SCRIPT = '\u001c';
        public static final char COMMANDCHAR_REDUCED_ICON = '\u001d';
        public static final char COMMANDCHAR_SICN = '\u001e';
        public static final char MACROMAN_COMMAND_KEY = '\u0011';
        public static final char MACROMAN_CHECK_MARK = '\u0012';
        public static final char MACROMAN_DIAMOND = '\u0013';
        public static final char MACROMAN_CLOSED_APPLE = '\u0014';
        public static final char UNICODE_COMMAND_KEY = '\u2318';
        public static final char UNICODE_CHECK_MARK = '\u2713';
        public static final char UNICODE_DIAMOND = '\u25c6';
        public static final char UNICODE_CLOSED_APPLE = '\uf8ff';
        public static final byte STYLE_BOLD = 1;
        public static final byte STYLE_ITALIC = 2;
        public static final byte STYLE_UNDERLINE = 4;
        public static final byte STYLE_OUTLINE = 8;
        public static final byte STYLE_SHADOW = 16;
        public static final byte STYLE_CONDENSE = 32;
        public static final byte STYLE_EXTEND = 64;
        public boolean enabled;
        public String menuItemName;
        public short iconID;
        public char commandChar;
        public char markChar;
        public short submenuID;
        public byte style;
        public int commandNumber;

        public void fixChars() {
            switch (this.commandChar) {
                case '\u0011': {
                    this.commandChar = (char)8984;
                    break;
                }
                case '\u0012': {
                    this.commandChar = (char)10003;
                    break;
                }
                case '\u0013': {
                    this.commandChar = (char)9670;
                    break;
                }
                case '\u0014': {
                    this.commandChar = (char)63743;
                }
            }
            switch (this.markChar) {
                case '\u0011': {
                    this.markChar = (char)8984;
                    break;
                }
                case '\u0012': {
                    this.markChar = (char)10003;
                    break;
                }
                case '\u0013': {
                    this.markChar = (char)9670;
                    break;
                }
                case '\u0014': {
                    this.markChar = (char)63743;
                }
            }
            this.menuItemName = this.menuItemName.replace('\u0011', '\u2318');
            this.menuItemName = this.menuItemName.replace('\u0012', '\u2713');
            this.menuItemName = this.menuItemName.replace('\u0013', '\u25c6');
            this.menuItemName = this.menuItemName.replace('\u0014', '\uf8ff');
        }

        public void unfixChars() {
            switch (this.commandChar) {
                case '\u2318': {
                    this.commandChar = (char)17;
                    break;
                }
                case '\u2713': {
                    this.commandChar = (char)18;
                    break;
                }
                case '\u25c6': {
                    this.commandChar = (char)19;
                    break;
                }
                case '\uf8ff': {
                    this.commandChar = (char)20;
                }
            }
            switch (this.markChar) {
                case '\u2318': {
                    this.markChar = (char)17;
                    break;
                }
                case '\u2713': {
                    this.markChar = (char)18;
                    break;
                }
                case '\u25c6': {
                    this.markChar = (char)19;
                    break;
                }
                case '\uf8ff': {
                    this.markChar = (char)20;
                }
            }
            this.menuItemName = this.menuItemName.replace('\u2318', '\u0011');
            this.menuItemName = this.menuItemName.replace('\u2713', '\u0012');
            this.menuItemName = this.menuItemName.replace('\u25c6', '\u0013');
            this.menuItemName = this.menuItemName.replace('\uf8ff', '\u0014');
        }

        public Map<TextAttribute, ?> getAttributes(Font f) {
            HashMap<TextAttribute, Object> m = new HashMap<TextAttribute, Object>();
            m.putAll(f.getAttributes());
            if ((this.style & 1) != 0) {
                m.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else {
                m.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
            }
            if ((this.style & 2) != 0) {
                m.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else {
                m.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
            }
            if ((this.style & 4) != 0) {
                m.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if ((this.style & 0x20) != 0) {
                m.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
            } else if ((this.style & 0x40) != 0) {
                m.put(TextAttribute.WIDTH, TextAttribute.WIDTH_EXTENDED);
            } else {
                m.put(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            }
            return m;
        }

        private Image getIcon(MacResourceProvider rp) {
            IconResource i;
            if (this.iconID == 0 || rp == null) {
                return null;
            }
            ColorIconResource ci = rp.get(1667851118, this.iconID).shallowRecast(ColorIconResource.class);
            if (ci != null) {
                try {
                    return ci.getImage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((i = rp.get(1229147982, this.iconID).shallowRecast(IconResource.class)) != null) {
                try {
                    return i.getImage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Image getReducedIcon(MacResourceProvider rp) {
            Graphics g;
            int h;
            int w;
            BufferedImage small;
            Image big = this.getIcon(rp);
            if (big != null && (small = new BufferedImage(w = big.getWidth(null) / 2, h = big.getHeight(null) / 2, 2)) != null && (g = small.getGraphics()) != null) {
                g.drawImage(big, 0, 0, w, h, null);
                return small;
            }
            return null;
        }

        private Image getSmallIcon(MacResourceProvider rp) {
            if (this.iconID == 0 || rp == null) {
                return null;
            }
            IconListResource i = rp.get(1397310286, this.iconID).shallowRecast(IconListResource.class);
            if (i != null) {
                try {
                    return i.getIcon(0).getImage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private MenuShortcut getShortcut() {
            switch (this.commandChar) {
                case 'A': 
                case 'a': {
                    return new MenuShortcut(65, false);
                }
                case 'B': 
                case 'b': {
                    return new MenuShortcut(66, false);
                }
                case 'C': 
                case 'c': {
                    return new MenuShortcut(67, false);
                }
                case 'D': 
                case 'd': {
                    return new MenuShortcut(68, false);
                }
                case 'E': 
                case 'e': {
                    return new MenuShortcut(69, false);
                }
                case 'F': 
                case 'f': {
                    return new MenuShortcut(70, false);
                }
                case 'G': 
                case 'g': {
                    return new MenuShortcut(71, false);
                }
                case 'H': 
                case 'h': {
                    return new MenuShortcut(72, false);
                }
                case 'I': 
                case 'i': {
                    return new MenuShortcut(73, false);
                }
                case 'J': 
                case 'j': {
                    return new MenuShortcut(74, false);
                }
                case 'K': 
                case 'k': {
                    return new MenuShortcut(75, false);
                }
                case 'L': 
                case 'l': {
                    return new MenuShortcut(76, false);
                }
                case 'M': 
                case 'm': {
                    return new MenuShortcut(77, false);
                }
                case 'N': 
                case 'n': {
                    return new MenuShortcut(78, false);
                }
                case 'O': 
                case 'o': {
                    return new MenuShortcut(79, false);
                }
                case 'P': 
                case 'p': {
                    return new MenuShortcut(80, false);
                }
                case 'Q': 
                case 'q': {
                    return new MenuShortcut(81, false);
                }
                case 'R': 
                case 'r': {
                    return new MenuShortcut(82, false);
                }
                case 'S': 
                case 's': {
                    return new MenuShortcut(83, false);
                }
                case 'T': 
                case 't': {
                    return new MenuShortcut(84, false);
                }
                case 'U': 
                case 'u': {
                    return new MenuShortcut(85, false);
                }
                case 'V': 
                case 'v': {
                    return new MenuShortcut(86, false);
                }
                case 'W': 
                case 'w': {
                    return new MenuShortcut(87, false);
                }
                case 'X': 
                case 'x': {
                    return new MenuShortcut(88, false);
                }
                case 'Y': 
                case 'y': {
                    return new MenuShortcut(89, false);
                }
                case 'Z': 
                case 'z': {
                    return new MenuShortcut(90, false);
                }
                case '1': {
                    return new MenuShortcut(49, false);
                }
                case '2': {
                    return new MenuShortcut(50, false);
                }
                case '3': {
                    return new MenuShortcut(51, false);
                }
                case '4': {
                    return new MenuShortcut(52, false);
                }
                case '5': {
                    return new MenuShortcut(53, false);
                }
                case '6': {
                    return new MenuShortcut(54, false);
                }
                case '7': {
                    return new MenuShortcut(55, false);
                }
                case '8': {
                    return new MenuShortcut(56, false);
                }
                case '9': {
                    return new MenuShortcut(57, false);
                }
                case '0': {
                    return new MenuShortcut(48, false);
                }
                case '!': {
                    return new MenuShortcut(49, true);
                }
                case '@': {
                    return new MenuShortcut(50, true);
                }
                case '#': {
                    return new MenuShortcut(51, true);
                }
                case '$': {
                    return new MenuShortcut(52, true);
                }
                case '%': {
                    return new MenuShortcut(53, true);
                }
                case '^': {
                    return new MenuShortcut(54, true);
                }
                case '&': {
                    return new MenuShortcut(55, true);
                }
                case '*': {
                    return new MenuShortcut(56, true);
                }
                case '(': {
                    return new MenuShortcut(57, true);
                }
                case ')': {
                    return new MenuShortcut(48, true);
                }
                case '`': {
                    return new MenuShortcut(192, false);
                }
                case '~': {
                    return new MenuShortcut(192, true);
                }
                case '-': {
                    return new MenuShortcut(45, false);
                }
                case '_': {
                    return new MenuShortcut(45, true);
                }
                case '=': {
                    return new MenuShortcut(61, false);
                }
                case '+': {
                    return new MenuShortcut(61, true);
                }
                case '[': {
                    return new MenuShortcut(91, false);
                }
                case '{': {
                    return new MenuShortcut(91, true);
                }
                case ']': {
                    return new MenuShortcut(93, false);
                }
                case '}': {
                    return new MenuShortcut(93, true);
                }
                case '\\': {
                    return new MenuShortcut(92, false);
                }
                case '|': {
                    return new MenuShortcut(92, true);
                }
                case ';': {
                    return new MenuShortcut(59, false);
                }
                case ':': {
                    return new MenuShortcut(59, true);
                }
                case '\'': {
                    return new MenuShortcut(222, false);
                }
                case '\"': {
                    return new MenuShortcut(222, true);
                }
                case ',': {
                    return new MenuShortcut(44, false);
                }
                case '<': {
                    return new MenuShortcut(44, true);
                }
                case '.': {
                    return new MenuShortcut(46, false);
                }
                case '>': {
                    return new MenuShortcut(46, true);
                }
                case '/': {
                    return new MenuShortcut(47, false);
                }
                case '?': {
                    return new MenuShortcut(47, true);
                }
            }
            return null;
        }

        public java.awt.MenuItem makeMenuItem(MacResourceProvider rp) {
            if (this.commandChar == '\u001b') {
                Menu m = rp.get(1296387669, this.submenuID).shallowRecast(MenuResource.class).makeMenu(rp);
                m.setEnabled(this.enabled);
                m.setLabel(this.menuItemName);
                m.setFont(new Font(this.getAttributes(m.getFont())));
                return m;
            }
            java.awt.MenuItem m = new java.awt.MenuItem(this.menuItemName);
            m.setEnabled(this.enabled);
            switch (this.commandChar) {
                case '\u0000': 
                case '\u001c': {
                    break;
                }
                case '\u001d': {
                    break;
                }
                case '\u001e': {
                    break;
                }
                default: {
                    m.setShortcut(this.getShortcut());
                }
            }
            m.setFont(new Font(this.getAttributes(m.getFont())));
            return m;
        }

        public JMenuItem makeJMenuItem(MacResourceProvider rp) {
            if (this.commandChar == '\u001b') {
                Image i;
                JMenu m = rp.get(1296387669, this.submenuID).shallowRecast(MenuResource.class).makeJMenu(rp);
                m.setEnabled(this.enabled);
                m.setText(this.menuItemName);
                if (this.iconID != 0 && (i = this.getIcon(rp)) != null) {
                    m.setIcon(new ImageIcon(i));
                }
                m.setFont(new Font(this.getAttributes(m.getFont())));
                return m;
            }
            JMenuItem m = new JMenuItem(this.menuItemName);
            m.setEnabled(this.enabled);
            switch (this.commandChar) {
                case '\u0000': 
                case '\u001c': {
                    break;
                }
                case '\u001d': {
                    Image i;
                    if (this.iconID == 0 || (i = this.getReducedIcon(rp)) == null) break;
                    m.setIcon(new ImageIcon(i));
                    break;
                }
                case '\u001e': {
                    Image i;
                    if (this.iconID == 0 || (i = this.getSmallIcon(rp)) == null) break;
                    m.setIcon(new ImageIcon(i));
                    break;
                }
                default: {
                    Image i;
                    if (this.iconID != 0 && (i = this.getIcon(rp)) != null) {
                        m.setIcon(new ImageIcon(i));
                    }
                    m.setAccelerator(KeyStroke.getKeyStroke((int)this.commandChar, m.getToolkit().getMenuShortcutKeyMask()));
                }
            }
            m.setSelected(this.markChar != '\u0000');
            m.setFont(new Font(this.getAttributes(m.getFont())));
            return m;
        }
    }
}

