#!/usr/bin/python3
import version
from optparse import OptionParser

parser = OptionParser()
parser.add_option('-f', '--free', dest='free', action="store_true", help="generate non-commercial version")
(options, args) = parser.parse_args()

template = open('./scripts/snapcraft.yaml', 'r')
yaml = template.read();

if options.free:
	v = version.VERSION + "-free"
else:
	v = version.VERSION

yaml = yaml.replace("VERSION", v)

make_script = open('./build/snapsource/birdfont/Makefile', 'w+')
make_script.write("#Don't edit, the file is generated by a script\n")
make_script.write("all:\n")

if options.free:
    make_script.write ("\t./configure --valac-flags=\"-D FREE\"\n")
else:
    make_script.write ("\t./configure\n")

make_script.write("\t./build.py\n")
make_script.write("""

install:
	./install.py -d $(DESTDIR)
""")

build_script = open('./build/snapcraft.yaml', 'w+')
build_script.write(yaml)

