package org.inria.biomaj.ant.task;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.inria.biomaj.utils.BiomajUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * 
 * 13/03/09 - O. Sallou - Fix 7463 sometimes exception is raised if file cannot be deleted
 *
 */
public class XIncludeTask extends Task {

	public static Namespace xi = Namespace.getNamespace("xi","http://www.w3.org/2001/XInclude");

	/** File path to fill to fill xinclude node */
	private String in = "";

	/** File result from the process */
	private String out = "";

	@Override
	public void execute() throws BuildException {

		log("in:"+in,Project.MSG_VERBOSE);
		log("out:"+out,Project.MSG_VERBOSE);
		File inFile = new File(in);

		/** load the main node */
		Element root = loadRootNode(inFile);
		if (root == null)
			return;

		String currentPath = BiomajUtils.getRelativeDirectory(in);
		/** change all noe include by the contains of the pointed file !*/
		fillXInclude(root,currentPath);

		write(root,out);
	}


	private Element loadRootNode(File inFile) {

		Element root = null ;

		if(!inFile.exists()) 
		{
			log(inFile.getAbsolutePath() +" does not exist !",Project.MSG_ERR);
			return null;
		}

		try {
			SAXBuilder sxb = new SAXBuilder();
			Document document = sxb.build(inFile);
			root = document.getRootElement();

		} catch (Exception e) {
			log(e.getLocalizedMessage(),Project.MSG_ERR);
			return null;
		}
		return root;
	}


	private void fillXInclude (Element root,String currentPath) {

		if (root == null)
			{
			log("bad root node->(null)",Project.MSG_ERR);
			return ;
			}

		try {
			List<Element> lChild = root.getChildren("include", xi) ;
			//Vector<Element> l = new Vector<Element>();
			
			/** Creation des noeuds remplacant les xinclude */
			Vector<Integer> lIndex = new Vector<Integer>();
			Vector<Element> lC = new Vector<Element>();
			for (Element e : lChild) {
				//Element e = it.next();
				String path = e.getAttributeValue("href");
				String file = currentPath+"/"+path;
				File xmlFile = new File(file);
				if (!xmlFile.exists()) {
					lIndex.add(root.indexOf(e));
					lC.add(null);
					continue;
				}
				Element child = loadRootNode(xmlFile);
				//Element c = (Element) child.clone();
				fillXInclude(child,BiomajUtils.getRelativeDirectory(file));
				//l.add(child);
				log("change content :"+file,Project.MSG_VERBOSE);
				log("index :"+root.indexOf(e),Project.MSG_VERBOSE);
				//root.addContent(root.indexOf(e),(Element)child.clone());
				lIndex.add(root.indexOf(e));
				lC.add((Element)child.clone());
				log("node add....",Project.MSG_VERBOSE);
				//printNode(c);
				//e.removeContent();
				//e.setContent(child);
			}
			
			for (int i=0;i!=lC.size();i++) {
				if (lC.get(i) != null)
					root.addContent(lIndex.get(i), lC.get(i));
				root.removeContent(lIndex.get(i)+1);
			}
			
			root.removeChildren("include", xi);
			
			lChild = root.getChildren() ;
			
			for (Element e : lChild) {
				//Element e = it.next();
				fillXInclude(e,currentPath);;
			}
			
		} catch (Exception e) {
			log(e.getLocalizedMessage(),Project.MSG_ERR);
		}
	}

	
	
	// Fix 7463 sometimes exception is raised if file cannot be deleted
	private void write(Element root,String outFile) {
		
		Document document = root.getDocument();
		if (document==null)
			document=new Document(root);

		XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());

		try {	
			new File(outFile).delete();
		} catch (Exception ex) {
			log(ex.getLocalizedMessage(),Project.MSG_ERR);
		} 
		try {	
			out.output(document, new FileOutputStream(outFile,false));
		} catch (Exception ex) {
			log(ex.getLocalizedMessage(),Project.MSG_ERR);
		} 		
	}

	
	//debug
	
	private void printNode(Element e) {
		if (e == null)
			{
			log("node:null",Project.MSG_INFO);
			return;
			}
		
		Iterator<Element> it = e.getChildren().iterator() ;
		while (it.hasNext()) {
			Element elt = it.next();
			log("node:"+elt.getName(),Project.MSG_INFO);
			printNode(elt);
		}
	}
	
	public String getIn() {
		return in;
	}

	public void setIn(String in) {
		this.in = in;
	}

	public String getOut() {
		return out;
	}

	public void setOut(String out) {
		this.out = out;
	}





}
