#!/usr/bin/python
import sys
from oauth import oauth

(consumer_key, consumer_secret, actual_token, token_secret, url, 
  method, nonce, timestamp, signature_method) = sys.argv[1:]

signature_function = oauth.OAuthSignatureMethod_PLAINTEXT if signature_method == 'PLAINTEXT' else oauth.OAuthSignatureMethod_HMAC_SHA1

consumer=oauth.OAuthConsumer(consumer_key, consumer_secret)
token=oauth.OAuthToken(actual_token, token_secret); 
rq=oauth.OAuthRequest.from_consumer_and_token(consumer, token=token, 
  http_method=method, http_url=url,
  parameters={'oauth_nonce':nonce,'oauth_timestamp':timestamp});
rq.sign_request(signature_function(),consumer, token); 
headers = rq.to_header()
parts = [x.strip() for x in headers["Authorization"].split(",") if x.find("=") != -1]
smallparts = dict([x.split("=") for x in parts])
print "Signature from Python:    ", smallparts["oauth_signature"]

