
#include "verifier.h"

static void
vusage() {
	fprintf(stderr,
"Usage: nsverifier [-d #] [-v] [[-c] configfile]\n");
	exit(1);
}

/*ARGSUSED*/
int
main(int argc, char *argv[]) {
	int n;
	int ch;
	int result = -1;
	foreground = 1;

#ifdef _AUX_SOURCE
	set42sig();
#endif
	debugfile = savestr(_PATH_DEBUG, 1);

	user_id = getuid();
	group_id = getgid();

	desired_debug = debug;

	/* BSD has a better random number generator but it's not clear
	 * that we need it here.
	 */
	gettime(&tt);
	srand(((unsigned)getpid()) + (unsigned)tt.tv_usec);

	(void) umask(022);

	/* Save argv[] before getopt() destroys it -- needed for execvp(). */
	saved_argv = malloc(sizeof(char *) * (argc + 1));
	INSIST(saved_argv != NULL);
	for (n = 0; n < argc; n++) {
		saved_argv[n] = strdup(argv[n]);
		INSIST(saved_argv[n] != NULL);
	}
	saved_argv[argc] = NULL;
	/* XXX we need to free() this for clean shutdowns. */

	while ((ch = getopt(argc, argv, "c:d:v")) != -1) {
		switch (ch) {
		case 'c':
			if (conffile != NULL)
				(void)freestr(conffile);
			conffile = savestr(optarg, 1);
			break;

		case 'd':
			desired_debug = atoi(optarg);
			if (desired_debug <= 0)
				desired_debug = 1;
			break;

		case 'v':
			fprintf(stdout, "%s\n", Version);
			exit(0);

		case '?':
		default:
			vusage();
		}
	}
	argc -= optind;
	argv += optind;

	if (argc) {
		if (conffile != NULL)
			(void)freestr(conffile);
		conffile = savestr(*argv, 1);
		argc--, argv++;
	}
	if (argc)
		vusage();

	/*
	 * Make sure we don't inherit any open descriptors
	 * other than those that daemon() can deal with.
	 */
	for (n = sysconf(_SC_OPEN_MAX) - 1; n >= 0; n--)
		if (n != STDIN_FILENO &&
		    n != STDOUT_FILENO &&
		    n != STDERR_FILENO)
			(void) close(n);

	/* Establish global event context. */
	evCreate(&ev);

	/* Establish global resolver context. */
	res_ninit(&res);
	res.options &= ~(RES_DEFNAMES | RES_DNSRCH | RES_RECURSE);

	/*
	 * Set up logging.
	 */
	n = LOG_PID;
#ifdef LOG_NOWAIT
	n |= LOG_NOWAIT;
#endif
#ifdef LOG_NDELAY
	n |= LOG_NDELAY;
#endif
#if defined(LOG_CONS) && defined(USE_LOG_CONS)
	n |= LOG_CONS;
#endif
#ifdef SYSLOG_42BSD
	openlog("nsverifier", n);
#else
	openlog("nsverifier", n, ISC_FACILITY);
#endif

	init_logging();
	set_assertion_failure_callback(ns_assertion_failed);

#ifdef DEBUG
	use_desired_debug();
#endif

	/* Perform system-dependent initialization */
	custom_init();

	/*
	init_needs();
	init_signals();
	*/

	ns_notice(ns_log_default, "verifying configuration (%s).  %s", 
			  conffile ? conffile : "stdin", Version);

	/*
	 * Initialize and load database.
	 */
	gettime(&tt);
	/*
	buildservicelist();
	buildprotolist();
	*/
	result = vns_init(conffile);
	time(&boottime);
	resettime = boottime;

	if (result == 0)
	{
		ns_notice(ns_log_default, 
				  "configuration and zones loaded successfully.");
	}
	else if (result < 0)
	{
		ns_notice(ns_log_default, 
				  "failed to load configuration (%s).", 
				  conffile ? conffile : "stdin");
	}
	else if (result > 0)
	{
		ns_notice(ns_log_default, 
				  "%d errors detected loading zones.", result); 
	}


	gettime(&tt);

	if (server_options && server_options->pid_filename)
		(void)unlink(server_options->pid_filename);

	if (NS_OPTION_P(OPTION_DEALLOC_ON_EXIT))
		deallocate_everything();
	else
		shutdown_configuration();

	/* Cleanup for system-dependent stuff */
	custom_shutdown();
	
	return (result);
}
