;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s --remove-unused-names --precompute-propagate --fuzz-exec -all -S -o - \
;; RUN:   | filecheck %s
;; RUN: wasm-opt %s --remove-unused-names --precompute-propagate --fuzz-exec -all --nominal -S -o - \
;; RUN:   | filecheck %s --check-prefix=NOMNL

(module
 ;; CHECK:      (type $empty (struct ))
 ;; NOMNL:      (type $empty (struct_subtype  data))
 (type $empty (struct))

 ;; CHECK:      (type $struct (struct (field (mut i32))))
 ;; NOMNL:      (type $struct (struct_subtype (field (mut i32)) data))
 (type $struct (struct (mut i32)))

 ;; two incompatible struct types
 (type $A (struct (field (mut f32))))
 ;; CHECK:      (type $B (struct (field (mut f64))))
 ;; NOMNL:      (type $B (struct_subtype (field (mut f64)) data))
 (type $B (struct (field (mut f64))))

 ;; CHECK:      (type $func-return-i32 (func (result i32)))
 ;; NOMNL:      (type $func-return-i32 (func_subtype (result i32) func))
 (type $func-return-i32 (func (result i32)))

 ;; CHECK:      (import "fuzzing-support" "log-i32" (func $log (param i32)))
 ;; NOMNL:      (import "fuzzing-support" "log-i32" (func $log (param i32)))
 (import "fuzzing-support" "log-i32" (func $log (param i32)))

 ;; CHECK:      (func $test-fallthrough (result i32)
 ;; CHECK-NEXT:  (local $x funcref)
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (block (result funcref)
 ;; CHECK-NEXT:    (drop
 ;; CHECK-NEXT:     (call $test-fallthrough)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (ref.null func)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.const 1)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $test-fallthrough (type $func-return-i32) (result i32)
 ;; NOMNL-NEXT:  (local $x funcref)
 ;; NOMNL-NEXT:  (local.set $x
 ;; NOMNL-NEXT:   (block (result funcref)
 ;; NOMNL-NEXT:    (drop
 ;; NOMNL-NEXT:     (call $test-fallthrough)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (ref.null func)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (i32.const 1)
 ;; NOMNL-NEXT: )
 (func $test-fallthrough (result i32)
  (local $x funcref)
  (local.set $x
   ;; the fallthrough value should be used. for that to be possible with a block
   ;; we need for it not to have a name, which is why --remove-unused-names is
   ;; run
   (block (result (funcref))
    ;; make a call so the block is not trivially removable
    (drop
     (call $test-fallthrough)
    )
    (ref.null func)
   )
  )
  ;; the null in the local should be propagated to here
  (ref.is_null
   (local.get $x)
  )
 )

 ;; CHECK:      (func $load-from-struct
 ;; CHECK-NEXT:  (local $x (ref null $struct))
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (struct.new_with_rtt $struct
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (rtt.canon $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (struct.new_with_rtt $struct
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:    (rtt.canon $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (struct.set $struct 0
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:   (i32.const 3)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $load-from-struct (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $x (ref null $struct))
 ;; NOMNL-NEXT:  (local.set $x
 ;; NOMNL-NEXT:   (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:    (rtt.canon $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $x
 ;; NOMNL-NEXT:   (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:    (i32.const 2)
 ;; NOMNL-NEXT:    (rtt.canon $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (struct.set $struct 0
 ;; NOMNL-NEXT:   (local.get $x)
 ;; NOMNL-NEXT:   (i32.const 3)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $load-from-struct
  (local $x (ref null $struct))
  (local.set $x
   (struct.new_with_rtt $struct
    (i32.const 1)
    (rtt.canon $struct)
   )
  )
  ;; we don't precompute these, as we don't know if the GC data was modified
  ;; elsewhere (we'd need immutability or escape analysis)
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
  ;; Assign a new struct
  (local.set $x
   (struct.new_with_rtt $struct
    (i32.const 2)
    (rtt.canon $struct)
   )
  )
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
  ;; Assign a new value
  (struct.set $struct 0
   (local.get $x)
   (i32.const 3)
  )
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
 )
 ;; CHECK:      (func $load-from-struct-bad-merge (param $i i32)
 ;; CHECK-NEXT:  (local $x (ref null $struct))
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $i)
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (struct.new_with_rtt $struct
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:     (rtt.canon $struct)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $x
 ;; CHECK-NEXT:    (struct.new_with_rtt $struct
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:     (rtt.canon $struct)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $load-from-struct-bad-merge (type $i32_=>_none) (param $i i32)
 ;; NOMNL-NEXT:  (local $x (ref null $struct))
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (local.get $i)
 ;; NOMNL-NEXT:   (local.set $x
 ;; NOMNL-NEXT:    (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:     (i32.const 1)
 ;; NOMNL-NEXT:     (rtt.canon $struct)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $x
 ;; NOMNL-NEXT:    (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:     (i32.const 2)
 ;; NOMNL-NEXT:     (rtt.canon $struct)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $load-from-struct-bad-merge (param $i i32)
  (local $x (ref null $struct))
  ;; a merge of two different $x values cannot be precomputed
  (if
   (local.get $i)
   (local.set $x
    (struct.new_with_rtt $struct
     (i32.const 1)
     (rtt.canon $struct)
    )
   )
   (local.set $x
    (struct.new_with_rtt $struct
     (i32.const 2)
     (rtt.canon $struct)
    )
   )
  )
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
 )
 ;; CHECK:      (func $modify-gc-heap (param $x (ref null $struct))
 ;; CHECK-NEXT:  (struct.set $struct 0
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (struct.get $struct 0
 ;; CHECK-NEXT:     (local.get $x)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $modify-gc-heap (type $ref?|$struct|_=>_none) (param $x (ref null $struct))
 ;; NOMNL-NEXT:  (struct.set $struct 0
 ;; NOMNL-NEXT:   (local.get $x)
 ;; NOMNL-NEXT:   (i32.add
 ;; NOMNL-NEXT:    (struct.get $struct 0
 ;; NOMNL-NEXT:     (local.get $x)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $modify-gc-heap (param $x (ref null $struct))
  (struct.set $struct 0
   (local.get $x)
   (i32.add
    (struct.get $struct 0
     (local.get $x)
    )
    (i32.const 1)
   )
  )
 )
 ;; --fuzz-exec verifies the output of this function, checking that the change
 ;; makde in modify-gc-heap is not ignored
 ;; CHECK:      (func $load-from-struct-bad-escape
 ;; CHECK-NEXT:  (local $x (ref null $struct))
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (struct.new_with_rtt $struct
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (rtt.canon $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $modify-gc-heap
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $load-from-struct-bad-escape (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $x (ref null $struct))
 ;; NOMNL-NEXT:  (local.set $x
 ;; NOMNL-NEXT:   (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:    (rtt.canon $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $modify-gc-heap
 ;; NOMNL-NEXT:   (local.get $x)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $load-from-struct-bad-escape (export "test")
  (local $x (ref null $struct))
  (local.set $x
   (struct.new_with_rtt $struct
    (i32.const 1)
    (rtt.canon $struct)
   )
  )
  (call $modify-gc-heap
   (local.get $x)
  )
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
 )
 ;; CHECK:      (func $load-from-struct-bad-arrive (param $x (ref null $struct))
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (struct.get $struct 0
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $load-from-struct-bad-arrive (type $ref?|$struct|_=>_none) (param $x (ref null $struct))
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (struct.get $struct 0
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $load-from-struct-bad-arrive (param $x (ref null $struct))
  ;; a parameter cannot be precomputed
  (call $log
   (struct.get $struct 0 (local.get $x))
  )
 )
 ;; CHECK:      (func $ref-comparisons (param $x (ref null $struct)) (param $y (ref null $struct))
 ;; CHECK-NEXT:  (local $z (ref null $struct))
 ;; CHECK-NEXT:  (local $w (ref null $struct))
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:    (local.get $y)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:    (ref.null $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:    (ref.null $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $ref-comparisons (type $ref?|$struct|_ref?|$struct|_=>_none) (param $x (ref null $struct)) (param $y (ref null $struct))
 ;; NOMNL-NEXT:  (local $z (ref null $struct))
 ;; NOMNL-NEXT:  (local $w (ref null $struct))
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:    (local.get $y)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:    (ref.null $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $x)
 ;; NOMNL-NEXT:    (ref.null $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (call $log
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $ref-comparisons
  (param $x (ref null $struct))
  (param $y (ref null $struct))
  (local $z (ref null $struct))
  (local $w (ref null $struct))
  ;; incoming parameters are unknown
  (call $log
   (ref.eq
    (local.get $x)
    (local.get $y)
   )
  )
  (call $log
   (ref.eq
    (local.get $x)
    ;; locals are ref.null which are known, and will be propagated
    (local.get $z)
   )
  )
  (call $log
   (ref.eq
    (local.get $x)
    (local.get $w)
   )
  )
  ;; null-initialized locals are known and can be compared
  (call $log
   (ref.eq
    (local.get $z)
    (local.get $w)
   )
  )
 )
 ;; CHECK:      (func $new-ref-comparisons (result i32)
 ;; CHECK-NEXT:  (local $x (ref null $struct))
 ;; CHECK-NEXT:  (local $y (ref null $struct))
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (struct.new_with_rtt $struct
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:    (rtt.canon $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $y
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.const 1)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $new-ref-comparisons (type $func-return-i32) (result i32)
 ;; NOMNL-NEXT:  (local $x (ref null $struct))
 ;; NOMNL-NEXT:  (local $y (ref null $struct))
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local.set $x
 ;; NOMNL-NEXT:   (struct.new_with_rtt $struct
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:    (rtt.canon $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $y
 ;; NOMNL-NEXT:   (local.get $x)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (i32.const 1)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (i32.const 1)
 ;; NOMNL-NEXT: )
 (func $new-ref-comparisons (result i32)
  (local $x (ref null $struct))
  (local $y (ref null $struct))
  (local $tempresult i32)
  (local.set $x
   (struct.new_with_rtt $struct
    (i32.const 1)
    (rtt.canon $struct)
   )
  )
  (local.set $y
   (local.get $x)
  )
  ;; assign the result, so that propagate calculates the ref.eq. both $x and $y
  ;; must refer to the same data, so we can precompute a 1 here.
  (local.set $tempresult
   (ref.eq
    (local.get $x)
    (local.get $y)
   )
  )
  ;; and that 1 is propagated to here.
  (local.get $tempresult)
 )
 ;; CHECK:      (func $propagate-equal (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.tee $tempref
 ;; CHECK-NEXT:     (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:      (rtt.canon $empty)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.get $tempref)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.const 1)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-equal (type $func-return-i32) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.tee $tempref
 ;; NOMNL-NEXT:     (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:      (rtt.canon $empty)
 ;; NOMNL-NEXT:     )
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (local.get $tempref)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (i32.const 1)
 ;; NOMNL-NEXT: )
 (func $propagate-equal (result i32)
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  ;; assign the result, so that propagate calculates the ref.eq
  (local.set $tempresult
   (ref.eq
    ;; allocate one struct
    (local.tee $tempref
     (struct.new_with_rtt $empty
      (rtt.canon $empty)
     )
    )
    (local.get $tempref)
   )
  )
  ;; we can compute a 1 here as the ref.eq compares a struct to itself. note
  ;; that the ref.eq itself cannot be precomputed away (as it has side effects).
  (local.get $tempresult)
 )
 ;; CHECK:      (func $propagate-unequal (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-unequal (type $func-return-i32) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (i32.const 0)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (i32.const 0)
 ;; NOMNL-NEXT: )
 (func $propagate-unequal (result i32)
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  ;; assign the result, so that propagate calculates the ref.eq.
  ;; the structs are different, so we will precompute a 0 here, and as creating
  ;; heap data does not have side effects, we can in fact replace the ref.eq
  ;; with that value
  (local.set $tempresult
   ;; allocate two different structs
   (ref.eq
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
   )
  )
  (local.get $tempresult)
 )

 ;; CHECK:      (func $propagate-uncertain-param (param $input (ref $empty)) (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:     (rtt.canon $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.get $input)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $tempresult)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-uncertain-param (type $ref|$empty|_=>_i32) (param $input (ref $empty)) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:     (rtt.canon $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (local.get $input)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $tempresult)
 ;; NOMNL-NEXT: )
 (func $propagate-uncertain-param (param $input (ref $empty)) (result i32)
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local.set $tempresult
   ;; allocate a struct and compare it to a param, which we know nothing about,
   ;; so we can infer nothing here at all.
   (ref.eq
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
    (local.get $input)
   )
  )
  (local.get $tempresult)
 )

 ;; CHECK:      (func $propagate-different-params (param $input1 (ref $empty)) (param $input2 (ref $empty)) (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $input1)
 ;; CHECK-NEXT:    (local.get $input2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $tempresult)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-different-params (type $ref|$empty|_ref|$empty|_=>_i32) (param $input1 (ref $empty)) (param $input2 (ref $empty)) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $input1)
 ;; NOMNL-NEXT:    (local.get $input2)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $tempresult)
 ;; NOMNL-NEXT: )
 (func $propagate-different-params (param $input1 (ref $empty)) (param $input2 (ref $empty)) (result i32)
  (local $tempresult i32)
  (local.set $tempresult
   ;; We cannot say anything about parameters - they might alias, or not.
   (ref.eq
    (local.get $input1)
    (local.get $input2)
   )
  )
  (local.get $tempresult)
 )

 ;; CHECK:      (func $propagate-same-param (param $input (ref $empty)) (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $input)
 ;; CHECK-NEXT:    (local.get $input)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $tempresult)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-same-param (type $ref|$empty|_=>_i32) (param $input (ref $empty)) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $input)
 ;; NOMNL-NEXT:    (local.get $input)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $tempresult)
 ;; NOMNL-NEXT: )
 (func $propagate-same-param (param $input (ref $empty)) (result i32)
  (local $tempresult i32)
  (local.set $tempresult
   ;; We could optimize this in principle, but atm do not.
   ;; Note that optimize-instructions can handle patterns like this.
   (ref.eq
    (local.get $input)
    (local.get $input)
   )
  )
  (local.get $tempresult)
 )

 ;; CHECK:      (func $propagate-uncertain-local (result i32)
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local $stashedref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempref
 ;; CHECK-NEXT:   (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:    (rtt.canon $empty)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $stashedref
 ;; CHECK-NEXT:   (local.get $tempref)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (call $helper
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $tempref
 ;; CHECK-NEXT:    (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:     (rtt.canon $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $tempresult
 ;; CHECK-NEXT:   (ref.eq
 ;; CHECK-NEXT:    (local.get $tempref)
 ;; CHECK-NEXT:    (local.get $stashedref)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.get $tempresult)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-uncertain-local (type $func-return-i32) (result i32)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local $stashedref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempref
 ;; NOMNL-NEXT:   (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:    (rtt.canon $empty)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $stashedref
 ;; NOMNL-NEXT:   (local.get $tempref)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (call $helper
 ;; NOMNL-NEXT:    (i32.const 0)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $tempref
 ;; NOMNL-NEXT:    (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:     (rtt.canon $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $tempresult
 ;; NOMNL-NEXT:   (ref.eq
 ;; NOMNL-NEXT:    (local.get $tempref)
 ;; NOMNL-NEXT:    (local.get $stashedref)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.get $tempresult)
 ;; NOMNL-NEXT: )
 (func $propagate-uncertain-local (result i32)
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local $stashedref (ref null $empty))
  (local.set $tempref
   (struct.new_with_rtt $empty
    (rtt.canon $empty)
   )
  )
  (local.set $stashedref
   (local.get $tempref)
  )
  ;; This if makes it impossible to know what value the ref.eq later should
  ;; return.
  (if
   (call $helper
    (i32.const 0)
   )
   (local.set $tempref
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
   )
  )
  (local.set $tempresult
   (ref.eq
    (local.get $tempref)
    (local.get $stashedref)
   )
  )
  (local.get $tempresult)
 )

 ;; CHECK:      (func $propagate-uncertain-loop
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local $stashedref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempref
 ;; CHECK-NEXT:   (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:    (rtt.canon $empty)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $stashedref
 ;; CHECK-NEXT:   (local.get $tempref)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (loop $loop
 ;; CHECK-NEXT:   (local.set $tempresult
 ;; CHECK-NEXT:    (ref.eq
 ;; CHECK-NEXT:     (local.get $tempref)
 ;; CHECK-NEXT:     (local.get $stashedref)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $tempref
 ;; CHECK-NEXT:    (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:     (rtt.canon $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $loop
 ;; CHECK-NEXT:    (call $helper
 ;; CHECK-NEXT:     (local.get $tempresult)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-uncertain-loop (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local $stashedref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempref
 ;; NOMNL-NEXT:   (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:    (rtt.canon $empty)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $stashedref
 ;; NOMNL-NEXT:   (local.get $tempref)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (loop $loop
 ;; NOMNL-NEXT:   (local.set $tempresult
 ;; NOMNL-NEXT:    (ref.eq
 ;; NOMNL-NEXT:     (local.get $tempref)
 ;; NOMNL-NEXT:     (local.get $stashedref)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $tempref
 ;; NOMNL-NEXT:    (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:     (rtt.canon $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (br_if $loop
 ;; NOMNL-NEXT:    (call $helper
 ;; NOMNL-NEXT:     (local.get $tempresult)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $propagate-uncertain-loop
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local $stashedref (ref null $empty))
  (local.set $tempref
   (struct.new_with_rtt $empty
    (rtt.canon $empty)
   )
  )
  (local.set $stashedref
   (local.get $tempref)
  )
  (loop $loop
   ;; Each iteration in this loop may see a different struct, so we cannot
   ;; precompute the ref.eq here.
   (local.set $tempresult
    (ref.eq
     (local.get $tempref)
     (local.get $stashedref)
    )
   )
   (local.set $tempref
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
   )
   (br_if $loop
    (call $helper
     (local.get $tempresult)
    )
   )
  )
 )

 ;; CHECK:      (func $propagate-certain-loop
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local $stashedref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $tempref
 ;; CHECK-NEXT:   (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:    (rtt.canon $empty)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $stashedref
 ;; CHECK-NEXT:   (local.get $tempref)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (loop $loop
 ;; CHECK-NEXT:   (local.set $tempresult
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $loop
 ;; CHECK-NEXT:    (call $helper
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-certain-loop (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local $stashedref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $tempref
 ;; NOMNL-NEXT:   (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:    (rtt.canon $empty)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $stashedref
 ;; NOMNL-NEXT:   (local.get $tempref)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (loop $loop
 ;; NOMNL-NEXT:   (local.set $tempresult
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (br_if $loop
 ;; NOMNL-NEXT:    (call $helper
 ;; NOMNL-NEXT:     (i32.const 1)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $propagate-certain-loop
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local $stashedref (ref null $empty))
  ;; As above, but remove the new in the loop, so that each loop iteration does
  ;; in fact have the ref locals identical, and we can precompute a 1.
  (local.set $tempref
   (struct.new_with_rtt $empty
    (rtt.canon $empty)
   )
  )
  (local.set $stashedref
   (local.get $tempref)
  )
  (loop $loop
   (local.set $tempresult
    (ref.eq
     (local.get $tempref)
     (local.get $stashedref)
    )
   )
   (br_if $loop
    (call $helper
     (local.get $tempresult)
    )
   )
  )
 )

 ;; CHECK:      (func $propagate-certain-loop-2
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local $stashedref (ref null $empty))
 ;; CHECK-NEXT:  (loop $loop
 ;; CHECK-NEXT:   (local.set $tempref
 ;; CHECK-NEXT:    (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:     (rtt.canon $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $stashedref
 ;; CHECK-NEXT:    (local.get $tempref)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $tempresult
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $loop
 ;; CHECK-NEXT:    (call $helper
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-certain-loop-2 (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local $stashedref (ref null $empty))
 ;; NOMNL-NEXT:  (loop $loop
 ;; NOMNL-NEXT:   (local.set $tempref
 ;; NOMNL-NEXT:    (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:     (rtt.canon $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $stashedref
 ;; NOMNL-NEXT:    (local.get $tempref)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $tempresult
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (br_if $loop
 ;; NOMNL-NEXT:    (call $helper
 ;; NOMNL-NEXT:     (i32.const 1)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $propagate-certain-loop-2
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local $stashedref (ref null $empty))
  (loop $loop
   ;; Another example of a loop where we can optimize. Here the new is inside
   ;; the loop.
   (local.set $tempref
    (struct.new_with_rtt $empty
     (rtt.canon $empty)
    )
   )
   (local.set $stashedref
    (local.get $tempref)
   )
   (local.set $tempresult
    (ref.eq
     (local.get $tempref)
     (local.get $stashedref)
    )
   )
   (br_if $loop
    (call $helper
     (local.get $tempresult)
    )
   )
  )
 )

 ;; CHECK:      (func $propagate-possibly-certain-loop
 ;; CHECK-NEXT:  (local $tempresult i32)
 ;; CHECK-NEXT:  (local $tempref (ref null $empty))
 ;; CHECK-NEXT:  (local $stashedref (ref null $empty))
 ;; CHECK-NEXT:  (loop $loop
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (call $helper
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $tempref
 ;; CHECK-NEXT:     (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:      (rtt.canon $empty)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $stashedref
 ;; CHECK-NEXT:    (local.get $tempref)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $tempresult
 ;; CHECK-NEXT:    (ref.eq
 ;; CHECK-NEXT:     (local.get $tempref)
 ;; CHECK-NEXT:     (local.get $stashedref)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $loop
 ;; CHECK-NEXT:    (call $helper
 ;; CHECK-NEXT:     (local.get $tempresult)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $propagate-possibly-certain-loop (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $tempresult i32)
 ;; NOMNL-NEXT:  (local $tempref (ref null $empty))
 ;; NOMNL-NEXT:  (local $stashedref (ref null $empty))
 ;; NOMNL-NEXT:  (loop $loop
 ;; NOMNL-NEXT:   (if
 ;; NOMNL-NEXT:    (call $helper
 ;; NOMNL-NEXT:     (i32.const 0)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (local.set $tempref
 ;; NOMNL-NEXT:     (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:      (rtt.canon $empty)
 ;; NOMNL-NEXT:     )
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $stashedref
 ;; NOMNL-NEXT:    (local.get $tempref)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (local.set $tempresult
 ;; NOMNL-NEXT:    (ref.eq
 ;; NOMNL-NEXT:     (local.get $tempref)
 ;; NOMNL-NEXT:     (local.get $stashedref)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (br_if $loop
 ;; NOMNL-NEXT:    (call $helper
 ;; NOMNL-NEXT:     (local.get $tempresult)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $propagate-possibly-certain-loop
  (local $tempresult i32)
  (local $tempref (ref null $empty))
  (local $stashedref (ref null $empty))
  (loop $loop
   ;; As above, but move the set of $stashedref below the if. That means that
   ;; it must be identical to $tempref in each iteration. However, that is
   ;; something we cannot infer atm (while SSA could), so we do not infer
   ;; anything here for now.
   (if
    (call $helper
     (i32.const 0)
    )
    (local.set $tempref
     (struct.new_with_rtt $empty
      (rtt.canon $empty)
     )
    )
   )
   (local.set $stashedref
    (local.get $tempref)
   )
   (local.set $tempresult
    (ref.eq
     (local.get $tempref)
     (local.get $stashedref)
    )
   )
   (br_if $loop
    (call $helper
     (local.get $tempresult)
    )
   )
  )
 )

 ;; CHECK:      (func $helper (param $0 i32) (result i32)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $helper (type $i32_=>_i32) (param $0 i32) (result i32)
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $helper (param i32) (result i32)
  (unreachable)
 )

 ;; CHECK:      (func $odd-cast-and-get
 ;; CHECK-NEXT:  (local $temp (ref null $B))
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (ref.null $B)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (struct.get $B 0
 ;; CHECK-NEXT:    (ref.null $B)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $odd-cast-and-get (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $temp (ref null $B))
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (ref.null $B)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (struct.get $B 0
 ;; NOMNL-NEXT:    (ref.null $B)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $odd-cast-and-get
  (local $temp (ref null $B))
  ;; Try to cast a null of A to B. While the types are incompatible, ref.cast
  ;; returns a null when given a null (and the null must have the type that the
  ;; ref.cast instruction has, that is, the value is a null of type $B). So this
  ;; is an odd cast that "works".
  (local.set $temp
   (ref.cast
    (ref.null $A)
    (rtt.canon $B)
   )
  )
  (drop
   ;; Read from the local, which precompute should set to a null with the proper
   ;; type.
   (struct.get $B 0
    (local.get $temp)
   )
  )
 )

 ;; CHECK:      (func $odd-cast-and-get-tuple
 ;; CHECK-NEXT:  (local $temp ((ref null $B) i32))
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (tuple.make
 ;; CHECK-NEXT:    (ref.null $B)
 ;; CHECK-NEXT:    (i32.const 10)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (struct.get $B 0
 ;; CHECK-NEXT:    (ref.null $B)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $odd-cast-and-get-tuple (type $none_=>_none)
 ;; NOMNL-NEXT:  (local $temp ((ref null $B) i32))
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (tuple.make
 ;; NOMNL-NEXT:    (ref.null $B)
 ;; NOMNL-NEXT:    (i32.const 10)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (struct.get $B 0
 ;; NOMNL-NEXT:    (ref.null $B)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $odd-cast-and-get-tuple
  (local $temp ((ref null $B) i32))
  ;; As above, but with a tuple.
  (local.set $temp
   (tuple.make
    (ref.cast
     (ref.null $A)
     (rtt.canon $B)
    )
    (i32.const 10)
   )
  )
  (drop
   (struct.get $B 0
    (tuple.extract 0
     (local.get $temp)
    )
   )
  )
 )

 ;; CHECK:      (func $receive-f64 (param $0 f64)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $receive-f64 (type $f64_=>_none) (param $0 f64)
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $receive-f64 (param f64)
  (unreachable)
 )

 ;; CHECK:      (func $odd-cast-and-get-non-null (param $temp (ref $func-return-i32))
 ;; CHECK-NEXT:  (local.set $temp
 ;; CHECK-NEXT:   (ref.cast
 ;; CHECK-NEXT:    (ref.func $receive-f64)
 ;; CHECK-NEXT:    (rtt.canon $func-return-i32)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call_ref
 ;; CHECK-NEXT:    (local.get $temp)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $odd-cast-and-get-non-null (type $ref|$func-return-i32|_=>_none) (param $temp (ref $func-return-i32))
 ;; NOMNL-NEXT:  (local.set $temp
 ;; NOMNL-NEXT:   (ref.cast
 ;; NOMNL-NEXT:    (ref.func $receive-f64)
 ;; NOMNL-NEXT:    (rtt.canon $func-return-i32)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call_ref
 ;; NOMNL-NEXT:    (local.get $temp)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $odd-cast-and-get-non-null (param $temp (ref $func-return-i32))
  ;; Try to cast a function to an incompatible type.
  (local.set $temp
   (ref.cast
    (ref.func $receive-f64)
    (rtt.canon $func-return-i32)
   )
  )
  (drop
   ;; Read from the local, checking whether precompute set a value there (it
   ;; should not, as the cast fails).
   (call_ref
    (local.get $temp)
   )
  )
 )

 ;; Regression test checking that breaking RTTs are interpreted correctly.
 ;; CHECK:      (func $cast-breaking-rtt
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.cast
 ;; CHECK-NEXT:    (ref.cast
 ;; CHECK-NEXT:     (struct.new_default $struct)
 ;; CHECK-NEXT:     (call $unreachable-rtt)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (call $unreachable-rtt)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $cast-breaking-rtt (type $none_=>_none)
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (ref.cast
 ;; NOMNL-NEXT:    (ref.cast
 ;; NOMNL-NEXT:     (struct.new_default $struct)
 ;; NOMNL-NEXT:     (call $unreachable-rtt)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:    (call $unreachable-rtt)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $cast-breaking-rtt
  (drop
   (ref.cast
    (ref.cast
     (struct.new_default $struct)
     (call $unreachable-rtt)
    )
    (call $unreachable-rtt)
   )
  )
 )

 ;; CHECK:      (func $unreachable-rtt (result (rtt $struct))
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $unreachable-rtt (type $none_=>_rtt_$struct) (result (rtt $struct))
 ;; NOMNL-NEXT:  (unreachable)
 ;; NOMNL-NEXT: )
 (func $unreachable-rtt (result (rtt $struct))
  (unreachable)
 )

 ;; CHECK:      (func $new_block_unreachable (result anyref)
 ;; CHECK-NEXT:  (block ;; (replaces something unreachable we can't emit)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (block
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (rtt.canon $struct)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $new_block_unreachable (type $none_=>_anyref) (result anyref)
 ;; NOMNL-NEXT:  (block ;; (replaces something unreachable we can't emit)
 ;; NOMNL-NEXT:   (drop
 ;; NOMNL-NEXT:    (block
 ;; NOMNL-NEXT:     (unreachable)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (drop
 ;; NOMNL-NEXT:    (rtt.canon $struct)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $new_block_unreachable (result anyref)
  (struct.new_with_rtt $struct
   ;; The value is a block with an unreachable. precompute will get rid of the
   ;; block, after which fuzz-exec should not crash - this is a regression test
   ;; for us being careful in how we execute an unreachable struct.new
   (block $label$1 (result i32)
    (unreachable)
   )
   (rtt.canon $struct)
  )
 )

 ;; CHECK:      (func $br_on_cast-on-creation-rtt (result (ref $empty))
 ;; CHECK-NEXT:  (block $label (result (ref $empty))
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (br_on_cast $label
 ;; CHECK-NEXT:     (struct.new_default_with_rtt $empty
 ;; CHECK-NEXT:      (rtt.canon $empty)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (rtt.canon $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $br_on_cast-on-creation-rtt (type $none_=>_ref|$empty|) (result (ref $empty))
 ;; NOMNL-NEXT:  (block $label (result (ref $empty))
 ;; NOMNL-NEXT:   (drop
 ;; NOMNL-NEXT:    (br_on_cast $label
 ;; NOMNL-NEXT:     (struct.new_default_with_rtt $empty
 ;; NOMNL-NEXT:      (rtt.canon $empty)
 ;; NOMNL-NEXT:     )
 ;; NOMNL-NEXT:     (rtt.canon $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (unreachable)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $br_on_cast-on-creation-rtt (result (ref $empty))
  (block $label (result (ref $empty))
   (drop
    ;; The br_on_cast will read the GC data created from struct.new, which must
    ;; emit it properly, including with an RTT which it will read from (since
    ;; this instructions uses an RTT).
    (br_on_cast $label
     (struct.new_default_with_rtt $empty
      (rtt.canon $empty)
     )
     (rtt.canon $empty)
    )
   )
   (unreachable)
  )
 )

 ;; CHECK:      (func $br_on_cast-on-creation-nortt (result (ref $empty))
 ;; CHECK-NEXT:  (block $label (result (ref $empty))
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (br_on_cast_static $label $empty
 ;; CHECK-NEXT:     (struct.new_default $empty)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $br_on_cast-on-creation-nortt (type $none_=>_ref|$empty|) (result (ref $empty))
 ;; NOMNL-NEXT:  (block $label (result (ref $empty))
 ;; NOMNL-NEXT:   (drop
 ;; NOMNL-NEXT:    (br_on_cast_static $label $empty
 ;; NOMNL-NEXT:     (struct.new_default $empty)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:   (unreachable)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $br_on_cast-on-creation-nortt (result (ref $empty))
  (block $label (result (ref $empty))
   (drop
    ;; As above, but with no RTTs.
    (br_on_cast_static $label $empty
     (struct.new_default $empty)
    )
   )
   (unreachable)
  )
 )

 ;; CHECK:      (func $ref.is_null (param $param i32)
 ;; CHECK-NEXT:  (local $ref (ref null $empty))
 ;; CHECK-NEXT:  (local.set $ref
 ;; CHECK-NEXT:   (struct.new_default $empty)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $helper
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $ref
 ;; CHECK-NEXT:   (ref.null $empty)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $helper
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $param)
 ;; CHECK-NEXT:   (local.set $ref
 ;; CHECK-NEXT:    (struct.new_default $empty)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (call $helper
 ;; CHECK-NEXT:    (ref.is_null
 ;; CHECK-NEXT:     (local.get $ref)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 ;; NOMNL:      (func $ref.is_null (type $i32_=>_none) (param $param i32)
 ;; NOMNL-NEXT:  (local $ref (ref null $empty))
 ;; NOMNL-NEXT:  (local.set $ref
 ;; NOMNL-NEXT:   (struct.new_default $empty)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $helper
 ;; NOMNL-NEXT:    (i32.const 0)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (local.set $ref
 ;; NOMNL-NEXT:   (ref.null $empty)
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $helper
 ;; NOMNL-NEXT:    (i32.const 1)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (if
 ;; NOMNL-NEXT:   (local.get $param)
 ;; NOMNL-NEXT:   (local.set $ref
 ;; NOMNL-NEXT:    (struct.new_default $empty)
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT:  (drop
 ;; NOMNL-NEXT:   (call $helper
 ;; NOMNL-NEXT:    (ref.is_null
 ;; NOMNL-NEXT:     (local.get $ref)
 ;; NOMNL-NEXT:    )
 ;; NOMNL-NEXT:   )
 ;; NOMNL-NEXT:  )
 ;; NOMNL-NEXT: )
 (func $ref.is_null (param $param i32)
  (local $ref (ref null $empty))
  ;; Test ref.null on references, and also test that we can infer multiple
  ;; assignments in the same function, without confusion between them.
  (local.set $ref
   (struct.new $empty)
  )
  (drop
   (call $helper
    ;; The reference here is definitely not null.
    (ref.is_null
     (local.get $ref)
    )
   )
  )
  (local.set $ref
   (ref.null $empty)
  )
  (drop
   (call $helper
    ;; The reference here is definitely null.
    (ref.is_null
     (local.get $ref)
    )
   )
  )
  (if
   (local.get $param)
   (local.set $ref
    (struct.new $empty)
   )
  )
  (drop
   (call $helper
    ;; The reference here might be null.
    (ref.is_null
     (local.get $ref)
    )
   )
  )
 )
)
