(*pp cpp $ARCH_FLAGS *)

(* File: sw_arg.mli

    Copyright (C) 2007-

      Jane Street Holding, LLC
      Author: Markus Mottl
      email: mmottl\@janestcapital.com
      WWW: http://www.janestcapital.com/ocaml

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(** Sw_arg: sizer and writer combination *)

open Bigarray

open Common
open Size
open Write_ml

(** Type of pair of functions for computing the size of values and
    writing them. *)
type 'a sw_arg = 'a sizer * 'a writer
type ('a, 'b) sw_arg1 = 'a sw_arg -> 'b sw_arg
type ('a, 'b, 'c) sw_arg2 = 'a sw_arg -> ('b, 'c) sw_arg1
type ('a, 'b, 'c, 'd) sw_arg3 = 'a sw_arg -> ('b, 'c, 'd) sw_arg2

val bin_sw_arg_unit : unit sw_arg
val bin_sw_arg_bool : bool sw_arg
val bin_sw_arg_string : string sw_arg
val bin_sw_arg_char : char sw_arg
val bin_sw_arg_int : int sw_arg
val bin_sw_arg_float : float sw_arg
val bin_sw_arg_int32 : int32 sw_arg
val bin_sw_arg_int64 : int64 sw_arg
val bin_sw_arg_nativeint : nativeint sw_arg
val bin_sw_arg_nat0 : Nat0.t sw_arg
val bin_sw_arg_ref : ('a, 'a ref) sw_arg1
val bin_sw_arg_lazy : ('a, 'a lazy_t) sw_arg1
val bin_sw_arg_option : ('a, 'a option) sw_arg1
val bin_sw_arg_pair : ('a, 'b, 'a * 'b) sw_arg2
val bin_sw_arg_triple : ('a, 'b, 'c, 'a * 'b * 'c) sw_arg3
val bin_sw_arg_list : ('a, 'a list) sw_arg1
val bin_sw_arg_array : ('a, 'a array) sw_arg1
val bin_sw_arg_hashtbl : ('a, 'b, ('a, 'b) Hashtbl.t) sw_arg2
val bin_sw_arg_float32_vec : vec32 sw_arg
val bin_sw_arg_float64_vec : vec64 sw_arg
val bin_sw_arg_vec : vec sw_arg
val bin_sw_arg_float32_mat : mat32 sw_arg
val bin_sw_arg_float64_mat : mat64 sw_arg
val bin_sw_arg_mat : mat sw_arg
val bin_sw_arg_bigstring : buf sw_arg
val bin_sw_arg_float_array : float array sw_arg
val bin_sw_arg_variant_tag : [> ] sw_arg
val bin_sw_arg_int_8bit : int sw_arg
val bin_sw_arg_int_16bit : int sw_arg
val bin_sw_arg_int_32bit : int sw_arg

#ifdef ARCH_SIXTYFOUR
val bin_sw_arg_int_64bit : int sw_arg
#endif

val bin_sw_arg_int64_bits : int64 sw_arg
val bin_sw_arg_array_no_length : ('a, 'a array) sw_arg1
