;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/progn.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 10:07:31 1994                          */
;*    Last change :  Thu Oct  6 10:28:06 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La normalisation des formes `begin'                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __progn
   
   (import  __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __param
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3)

   (use     __type
	    __evenv)
   
   (export  (normalize-progn <expression>)
	    (normalize-body  <expression>)
	    (replace! p1 p2)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    Cette fonction doit etre utilisee pour normalise du code         */
;*    utilisateur tel qu'il est lu par le lecteur.                     */
;*---------------------------------------------------------------------*/
(define (normalize-progn body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      ((and (pair? body) (null? (cdr body)))
       (car body))
      (else
       (let ((res `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
						 (cdr body)
						 body)))
			       (if (null? body)
				   '()
				   (let ((expr (car body)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr) (loop (cdr body)))
					  (cons expr (loop (cdr body))))))))))
	  (cond
	     ((epair? body)
	      (replace! body res))
	     ((epair? (car body))
	      (econs (car res) (cdr res) (cer (car body))))
	     (else
	      res)))))) 

;*---------------------------------------------------------------------*/
;*    normalize-body ...                                               */
;*    sexp --> sexp                                                    */
;*    -------------------------------------------------------------    */
;*    This function behaves as normalize-progn but it uses a different */
;*    strategy for setting location. It does not consider the current  */
;*    location as the prioritary location.                             */
;*---------------------------------------------------------------------*/
(define (normalize-body body)
   (cond
      ((not (pair? body))
       `(begin ,body))
      ((and (pair? body) (null? (cdr body)))
       (car body))
      (else
       (let ((res `(begin ,@(let loop ((body (if (eq? (car body) 'begin)
						 (cdr body)
						 body)))
			       (if (null? body)
				   '()
				   (let ((expr (car body)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr) (loop (cdr body)))
					  (cons expr (loop (cdr body))))))))))
	  (cond
	     ((epair? (car body))
	      (econs (car res) (cdr res) (cer (car body))))
	     (else
	      res)))))) 

;*---------------------------------------------------------------------*/
;*    replace! ...                                                     */
;*---------------------------------------------------------------------*/
(define (replace! p1 p2)
   (if (and (pair? p1) (pair? p2) (not (epair? p2)))
       (begin
	  (set-car! p1 (car p2))
	  (set-cdr! p1 (cdr p2))
	  p1)
       p2))

