;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/everror.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr 14 13:46:57 2004                          */
;*    Last change :  Thu Oct  6 10:27:41 2005 (serrano)                */
;*    Copyright   :  2004-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The error of evmeaning                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __everror

   (include "Eval/byte-code.sch")
   
   (import  __type
 	    __object
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    __bit
	    __param
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3)
	    
   (export *current-bcode*
	   (evmeaning-error ::obj ::obj ::obj ::obj)
	   (evmeaning-reset-error!)
	   (evmeaning-warning ::obj . ::obj)
	   (evmeaning-notify-error ::obj ::obj ::obj)
	   (evmeaning-notify-exception e)
	   (evmeaning-exception-handler ::obj)
	   (evmeaning-arity-error ::obj ::obj)))

;*---------------------------------------------------------------------*/
;*    *current-bcode* ...                                              */
;*---------------------------------------------------------------------*/
(define *current-bcode* #f)

;*---------------------------------------------------------------------*/
;*    evmeaning-reset-error! ...                                       */
;*---------------------------------------------------------------------*/
(define (evmeaning-reset-error!)
   (set! *current-bcode* #f))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-error ...                                              */
;*---------------------------------------------------------------------*/
(define (evmeaning-error bcode proc mes obj)
   (if (evcode? bcode)
       (match-case (evcode-loc bcode)
	  ((at ?fname ?loc)
	   (error/location proc mes obj fname loc))
	  (else
	   (error proc mes obj)))
       (error proc mes obj)))

;*---------------------------------------------------------------------*/
;*    evmeaning-warning ...                                            */
;*---------------------------------------------------------------------*/
(define (evmeaning-warning bcode . args)
   (if (evcode? bcode)
       (match-case (evcode-loc bcode)
	  ((at ?fname ?loc)
	   (raise (make-&eval-warning fname loc args)))
	  (else
	   (raise (make-&eval-warning #f #f args))))
       (raise (make-&eval-warning #f #f args))))

;*---------------------------------------------------------------------*/
;*    evmeaning-notify-error ...                                       */
;*---------------------------------------------------------------------*/
(define (evmeaning-notify-error proc mes obj)
   (bind-exit (escape)
      (with-exception-handler
       (lambda (e)
	  (error-notify e)
	  (escape #unspecified))
       (lambda ()
	  (cond
	     ((epair? obj)
	      (match-case (cer obj)
		 ((at ?fname ?loc)
		  (error/location proc mes obj fname loc))
		 (else
		  (error proc mes obj))))
	     ((evcode? *current-bcode*)
	      (match-case (evcode-loc *current-bcode*)
		 ((at ?fname ?loc)
		  (set! *current-bcode* #f)
		  (error/location proc mes obj fname loc))
		 (else
		  (error proc mes obj))))
	     (else
	      (error proc mes obj)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-notify-exception ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-notify-exception e)
   (when (&error? e)
      (if (evcode? *current-bcode*)
	  (match-case (evcode-loc *current-bcode*)
	     ((at ?fname ?loc)
	      (set! *current-bcode* #f)
	      (error-notify (duplicate::&error e
			       (fname fname)
			       (location loc))))
	     (else
	      (error-notify e)))
	  (error-notify e))))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-exception-handler ...                                  */
;*---------------------------------------------------------------------*/
(define (evmeaning-exception-handler e)
   (if (&error? e)
       (if (evcode? *current-bcode*)
	   (match-case (evcode-loc *current-bcode*)
	      ((at ?fname ?loc)
	       (set! *current-bcode* #f)
	       (raise (duplicate::&error e
			 (fname fname)
			 (location loc))))
	      (else
	       (raise e)))
	   (raise e))
       (raise e)))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-arity-error ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-arity-error code name)
   (evmeaning-error code 'eval "Incorrect number of arguments" name))

