;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/system.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Oct 17 07:53:29 2002                          */
;*    Last change :  Wed Jun 22 07:30:16 2005 (serrano)                */
;*    Copyright   :  2002-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Test system features                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module system
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-system)))

;*---------------------------------------------------------------------*/
;*    test-system ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-system)
   (test-module "system" "system.scm")
   (test "pwd" (string? (pwd)) #t)
   (test "command-line" (pair? (command-line)) #t)
   (test "executable-name" (string? (executable-name)) #t)
   (test "file-separator" (char? (file-separator)) #t)
   (test "path-separator" (char? (path-separator)) #t)
   (test "make-file-name" (make-file-name "" "foo")
	 (string-append (string (file-separator)) "foo"))
   (test "make-file-name" (make-file-name "foo" "bar")
	 (string-append "foo" (string (file-separator)) "bar"))
   (test "make-file-path" (make-file-path "foo" "bar")
	 (string-append "foo" (string (file-separator)) "bar"))
   (test "make-file-path" (make-file-path "foo" "bar" "gee")
	 (string-append "foo" (string (file-separator))
			"bar" (string (file-separator))
			"gee"))
   (test "basename" (basename "foo") "foo")
   (test "basename" (basename (make-file-name "foo" "bar")) "bar")
   (test "basename" (basename (make-file-path "foo" "bar" "gee")) "gee")
   (test "dirname" (dirname "foo") ".")
   (test "dirname" (dirname "") ".")
   (test "dirname" (dirname (make-file-name "foo" "bar")) "foo")
   (test "dirname" (dirname (make-file-path "foo" "bar" "gee"))
	 (make-file-name "foo" "bar"))
   (test "prefix" (prefix "foo.scm") "foo")
   (test "prefix" (prefix (make-file-name "bar" "foo.scm"))
	 (make-file-name "bar" "foo"))
   (test "suffix" (suffix "foo.scm") "scm")
   (test "suffix" (suffix (make-file-name "bar" "foo.scm")) "scm")
   (test "make-static-library-name"
	 (string? (make-static-library-name "foo")) #t)
   (test "make-shared-library-name"
	 (string? (make-shared-library-name "foo")) #t)
   (test "os-class" (string? (os-class)) #t)
   (test "os-name" (string? (os-name)) #t)
   (test "os-version" (string? (os-version)) #t)
   (test "sleep" (sleep 15) 15)
   (test "file-modification-time" (elong? (file-modification-time "main.scm"))
	 #t)
   (test "unix-path->list" (list? (unix-path->list
				   (string-append "foo"
						  (string (path-separator))
						  "bar")))
	 #t)
   (test "runtime-os-name" (string? (car (list (os-name)))) #t)
   (test "runtime-os-version" (string? (car (list (os-version)))) #t)
   (test "socket" (string?
		   (with-output-to-string
		      (lambda () (display (make-server-socket 9999)))))
	 #t))



   
