;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/Llib/_thread.sch         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun  1 07:26:08 2003                          */
;*    Last change :  Fri Mar 11 10:48:04 2005 (serrano)                */
;*    Copyright   :  2003-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The declaration of the external thread bindings                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directive                                                    */
;*---------------------------------------------------------------------*/
(directives

   (extern (include "bglfthread.h")

	   ;; fair threads
	   (type $fthread (opaque) "bglfthread_t")
	   (macro $fthread-new::$fthread (::procedure)
		  "bglfth_thread_new")
	   (macro $fthread-new/name::$fthread (::procedure ::symbol)
		  "bglfth_thread_new_with_name")
	   (macro $fthread-id-set!::obj (::$fthread ::obj)
		  "bglfth_thread_id_set")
	   (macro $fthread-start::void (::$fthread ::obj)
		  "bglfth_thread_start")
	   (macro $fthread-wait::void (::$fthread)
		  "bglfth_thread_wait")
	   (macro $fthread-switch::void (::$fthread ::$fthread)
		  "bglfth_thread_switch")
	   (macro $fthread-enter-scheduler::void (::$fthread)
		  "bglfth_thread_enter_scheduler")
	   (macro $fthread-leave-scheduler::void (::$fthread)
		  "bglfth_thread_leave_scheduler")
	   
	   ;; asynchronous threads
	   (macro $async-spawn::void (::$fthread ::procedure ::obj)
		  "bglfth_async_spawn")
	   (macro $async-synchronize::void (::$fthread)
		  "bglfth_async_synchronize")
	   (macro $async-asynchronize::void (::$fthread)
		  "bglfth_async_asynchronize")
	   
	   (macro $async-scheduler-wait::void (::$fthread)
		  "bglfth_async_scheduler_wait")
	   (macro $async-scheduler-notify::void (::$fthread)
		  "bglfth_async_scheduler_notify"))
   
   (java   ;; fair threads
	   (class $fthread
	      (constructor new (::procedure))
	      (constructor new/name (::procedure ::symbol))
	      (method id-set!::obj (::$fthread ::obj) "idSet")
	      (method start::void (::$fthread ::obj) "start")
	      (method wait::void (::$fthread) "fairWait")
	      (method switch::void (::$fthread ::$fthread) "fairSwitch")
	      (method enter-scheduler::void (::$fthread) "enter_scheduler")
	      (method leave-scheduler::void (::$fthread) "leave_scheduler")
	      "bigloo.fthread.bglfthread")

	   ;; asynchronous threads
	   (class $async
	      (constructor spawn (::$fthread ::procedure ::obj))
	      (method static synchronize::obj (::$fthread ::procedure)
		      "synchronize")
	      (method static scheduler-wait::void (::$fthread)
		      "scheduler_wait")
	      (method static scheduler-notify::void (::$fthread)
		      "scheduler_notify")
	      "bigloo.fthread.bglasync")))

   
   
 
