;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/evmeaning.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Aug  4 10:48:41 1993                          */
;*    Last change :  Wed Jun  9 10:00:35 2004 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Bigloo's interpreter.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __evmeaning
   
   (include "Eval/byte-code.sch")
   
   (import  __type
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    __bit
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __progn
	    __evenv
	    __evcompile
	    __everror)

   (static  (update-eval-global! variable value))
   
   (export  (evmeaning exp env)
	    (evmeaning-location))
   
   (extern  (%funcall-0::obj (::procedure)
			     "eval_funcall_0")
	    (%funcall-1::obj (::procedure ::obj)
			     "eval_funcall_1")
	    (%funcall-2::obj (::procedure ::obj ::obj)
			     "eval_funcall_2")
	    (%funcall-3::obj (::procedure ::obj ::obj ::obj)
			     "eval_funcall_3")
	    (%funcall-4::obj (::procedure ::obj ::obj ::obj ::obj)
			     "eval_funcall_4")
	    (%eval-apply::obj (::procedure ::obj) "eval_apply")
	    (macro %procedure-eval::obj (::procedure)
		   "PROCEDURE_EVAL")
	    (macro %procedure-eval-set!::obj (::procedure ::obj)
		   "PROCEDURE_EVAL_SET"))
   
   (java    (class foreign
	       (method static %funcall-0::obj (::procedure)
		       "eval_funcall_0")
	       (method static %funcall-1::obj (::procedure ::obj)
		       "eval_funcall_1")
	       (method static %funcall-2::obj (::procedure ::obj ::obj)
		       "eval_funcall_2")
	       (method static %funcall-3::obj (::procedure ::obj ::obj ::obj)
		       "eval_funcall_3")
	       (method static %funcall-4::obj (::procedure ::obj ::obj ::obj ::obj)
		       "eval_funcall_4")
	       (method static %eval-apply::obj (::procedure ::obj)
		       "eval_apply")

	       (method static %procedure-eval::obj (::procedure)
		       "PROCEDURE_EVAL")
	       (method static %procedure-eval-set!::obj (::procedure ::obj)
		       "PROCEDURE_EVAL_SET"))))

;*---------------------------------------------------------------------*/
;*    case-bounce ...                                                  */
;*---------------------------------------------------------------------*/
(define-macro (case-bounce test . clauses)
   (let* ((bounce '())
	  (r `(case ,test
		 ,@(map (lambda (c)
			   (match-case c
			      (((bounce ?vars ((and (? integer?) ?n))) . ?body)
			       (let ((id (string->symbol
					  (string-append
					   "evmeaning-bounce-"
					   (integer->string n)))))
				  (set! bounce
					(cons `(define (,id ,@vars) ,@body)
					      bounce))
				  `((,n) (,id ,@vars))))
			      (((bounce . ?-) . ?-)
			       (error 'case-bounce "Illegal clause" c))
			      (else
			       c)))
			clauses))))
      (putprop! 'case-bounce 'bouncing bounce)
      r))

;*---------------------------------------------------------------------*/
;*    emit-bounced! ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (emit-bounced!)
   `(begin ,@(getprop 'case-bounce 'bouncing)))

;*---------------------------------------------------------------------*/
;*    evmeaning ...                                                    */
;*---------------------------------------------------------------------*/
(define (evmeaning code stack)
   (if (evcode? code)
       (begin
	  (set! *current-bcode* code)
 	  (case-bounce (evcode-op code)
             ;; les erreurs
	     ((-2)
	      (apply evmeaning-error code (evcode-ref code 0)))
	     ;; La seule constante qui nessecite un codage: les `vecteurs'
	     ((-1)
	      (evcode-ref code 0))
	     ;; la premiere variable locale
	     ((0)   
	      (car stack))
	     ;; la deuxieme variable locale
	     ((1)   
	      (cadr stack))
	     ;; la troisieme variable locale
	     ((2)   
	      (caddr stack))
	     ;; la quatrieme variable locale
	     ((3)   
	      (cadddr stack))
	     ;; les variables locales plus profondes
	     ((4)   
	      (let ((offset (evcode-ref code 0)))
		 (do ((i 4 (+fx i 1))
		      (env (cddddr stack) (cdr env)))
		     ((=fx i offset) (car env)))))
	     ;; la reference d'une variable globale mutable
	     ((5)
	      (__evmeaning_address-ref
	       (eval-global-value (evcode-ref code 0))))
	     ;; la reference d'une variable globale non mutable
	     ((6)
	      (eval-global-value (evcode-ref code 0)))
	     ;; la reference a une variable pas encore definie
	     ((bounce (code stack) (7))
	      (let* ((name (evcode-ref code 0))
		     (global (eval-lookup name)))
		 (if (eval-global? global)
		     (begin
			;; we change the value of the byte-code
			;; because, now, the variable is bound
			(evcode-op-set! code 6)
			(evcode-set! code 0 global)
			(eval-global-value global))
		     (evmeaning-error code
				      "eval"
				      "Unbound variable"
				      name))))
	     ;; la mutation d'une variable globale
	     ((8)
	      (let ((var (evcode-ref code 0))
		    (val (evmeaning (evcode-ref code 1) stack)))
		 (update-eval-global! var val)
		 (unspecified)))
	     ((bounce (code stack) (9))
	      ;; la mutation d'une variable pas encore definie
	      (let* ((name (evcode-ref code 0))
		     (value (evcode-ref code 1))
		     (global (eval-lookup name)))
		 (if (eval-global? global)
		     (begin
			(evcode-op-set! code 8)
			(evcode-set! code 0 global)
			(evcode-set! code 1 value)
			(evmeaning code stack))
		     (evmeaning-error code
				      "eval"
				      "Unbound variable"
				      name))))
	     ;; la mutation de la premiere variable locale
	     ((10)
	      (set-car! stack (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ;; la mutation de la deuxieme variable locale
	     ((11)
	      (set-car! (cdr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ;; la mutation de la troisieme variable locale
	     ((12)
	      (set-car! (cddr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ;; la mutation de la quatrieme variable locale
	     ((13)
	      (set-car! (cdddr stack) (evmeaning (evcode-ref code 0) stack))
	      (unspecified))
	     ;; la mutation des variables locales profondes
	     ((bounce (code stack) (14))
	      (let ((offset (evcode-ref code 0))
		    (value  (evmeaning (evcode-ref code 1) stack)))
		 (do ((i 4 (+fx i 1))
		      (env (cddddr stack) (cdr env)))
		     ((=fx i offset) (set-car! env value)))
		 (unspecified)))
	     ;; la conditionnelle
	     ((15) 
	      (if (evmeaning (evcode-ref code 0) stack)
		  (evmeaning (evcode-ref code 1) stack)
		  (evmeaning (evcode-ref code 2) stack)))
	     ((bounce (code stack) (67))
	      ;; or
	      (let ((len (evcode-length code)))
		 (let loop ((i 0))
		    (if (<fx i len)
			(or (evmeaning (evcode-ref code i) stack)
			    (loop (+fx i 1)))
			#f))))
	     ((bounce (code stack) (68))
	      ;; and
	      (let ((len (evcode-length code)))
		 (let loop ((i 0)
			    (l #t))
		    (if (<fx i len)
			(let ((l (evmeaning (evcode-ref code i) stack)))
			   (and l (loop (+fx i 1) l)))
			l))))
	     ;; sequence (by construction, the length is at least 1)
	     ((16)
	      (let ((len (-fx (evcode-length code) 1)))
		 (let loop ((i 0))
		    (if (=fx i len)
			(evmeaning (evcode-ref code i) stack)
			(begin
			   (evmeaning (evcode-ref code i) stack)
			   (loop (+fx i 1)))))))
	     ;; la forme define (globale) lambda
	     ((bounce (code stack) (17))
	      (let ((var (evcode-ref code 0))
		    (val (evcode-ref code 1)))
		 (let ((cell (eval-lookup var)))
		    (if (eval-global? cell)
			(begin
			   (evmeaning-warning code
					      "eval"
					      #\Newline
					      "redefinition of variable -- "
					      var)
			   (update-eval-global! cell
						(evmeaning (force val) '())))
			(let ((cell (vector 0 var (unspecified))))
 			   (bind-eval-global! var cell)
			   ;; on le fait en deux fois pour etre
			   ;; sur que la liaison existe.
			   (let ((value (evmeaning (force val) '())))
			      (set-eval-global-value! cell value))))
		    var)))
	     ;; la forme define (globale) value
	     ((bounce (code stack) (63))
	      (let* ((var (evcode-ref code 0))
		     (val (evmeaning (evcode-ref code 1) '())))
		 (let ((cell (eval-lookup var)))
		    (if (eval-global? cell)
			(begin
			   (evmeaning-warning code
					      "eval"
					      #\Newline
					      "redefinition of variable -- "
					      var)
			   (update-eval-global! cell val))
			(let ((cell (vector 0 var (unspecified))))
			   (bind-eval-global! var cell)
			   ;; on le fait en deux fois pour etre
			   ;; sur que la liaison existe.
			   (set-eval-global-value! cell val)))
		    var)))
	     ;; bind-exit
	     ((bounce (code stack) (18))
	      (bind-exit (__dummy__)
		 ((evmeaning (evcode-ref code 0) stack) __dummy__)))
	     ;; unwind-protect
	     ((bounce (code stack) (64))
	      (let ((body (evcode-ref code 0))
		    (protect (evcode-ref code 1)))
		 (unwind-protect (evmeaning body stack)
				 (evmeaning protect stack))))
	     ;; l'appel de fonction de compilee anonyme d'arite 0
	     ((bounce (code) (25))
	      ((evcode-ref code 0)))
	     ;; l'appel de fonction de compilee anonyme d'arite 1
	     ((bounce (code stack) (26))
	      (let* ((fun (evcode-ref code 0)))
		 (set! *current-bcode* code)
		 (fun (evmeaning (evcode-ref code 1) stack))))
	     ;; l'appel de fonction de compilee anonyme d'arite 2
	     ((bounce (code stack) (27))
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1)))
	     ;; l'appel de fonction de compilee anonyme d'arite 3
	     ((bounce (code stack) (28))
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack))
		     (a2 (evmeaning (evcode-ref code 3) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1 a2)))
	     ;; l'appel de fonction de compilee anonyme d'arite 4
	     ((bounce (code stack) (29))
	      (let* ((fun (evcode-ref code 0))
		     (a0 (evmeaning (evcode-ref code 1) stack))
		     (a1 (evmeaning (evcode-ref code 2) stack))
		     (a2 (evmeaning (evcode-ref code 3) stack))
		     (a3 (evmeaning (evcode-ref code 4) stack)))
		 (set! *current-bcode* code)
		 (fun a0 a1 a2 a3)))
	     ;; l'appel de fonction de compilee anonyme d'arite plus que 4
	     ((bounce (code stack) (30))
	      (let ((eargs (map (lambda (x)
				   (evmeaning x stack))
				(evcode-ref code 1))))
		 (set! *current-bcode* code)
		 (apply (evcode-ref code 0) eargs)))
	     ;; funcall 0
	     ((31)
	      (evmeaning-funcall-0 code stack))
	     ;; tailcall 0
	     ((131)
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-0-stack code stack fun))
		     (evmeaning-funcall-0 code stack))))
	     ;; funcall 1
	     ((32)
	      (evmeaning-funcall-1 code stack))
	     ;; tailcall 1
	     ((132)
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-1-stack code stack fun))
		     (evmeaning-funcall-1 code stack))))
	     ;; funcall 2
	     ((33)
	      (evmeaning-funcall-2 code stack))
	     ;; tailcall 2
	     ((133)
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-2-stack code stack fun))
		     (evmeaning-funcall-2 code stack))))
	     ;; funcall 3
	     ((34)
	      (evmeaning-funcall-3 code stack))
	     ;; tailcall 3
	     ((134)
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-3-stack code stack fun))
		     (evmeaning-funcall-3 code stack))))
	     ;; funcall 4
	     ((35)
	      (evmeaning-funcall-4 code stack))
	     ;; tailcall 4
	     ((135)
	      (let ((fun (evmeaning (evcode-ref code 1) stack)))
		 (if (evmeaning-procedure? fun)
		     (evmeaning (evmeaning-procedure-bcode fun)
				(evmeaning-tailcall-4-stack code stack fun))
		     (evmeaning-funcall-4 code stack))))
	     ;; funcall >4
	     ((bounce (code stack) (36))
	      (let* ((name (evcode-ref code 0))
		     (fun (evmeaning (evcode-ref code 1) stack)))
 		 (let loop ((args (evcode-ref code 2))
			    (new '())
			    (len 0))
		    (if (null? args)
			(begin
			   (set! *current-bcode* code)
			   (eval-apply name fun len (reverse! new)))
			(loop (cdr args)
			      (cons (evmeaning (car args) stack) new)
			      (+fx 1 len))))))
	     ;; tailcall >4
	     ((136)
	      (let* ((name (evcode-ref code 0))
		     (fun (evmeaning (evcode-ref code 1) stack)))
 		 (let loop ((args (evcode-ref code 2))
			    (new '())
			    (len 0))
		    (if (null? args)
			(if (evmeaning-procedure? fun)
			    (let* ((fmls (evmeaning-procedure-args fun))
				   (stack (evmeaning-procedure-stack fun))
				   (wen (reverse! new))
				   (e2 (if (>=fx fmls 0)
					   (evmeaning-push-fxargs name
								  code
								  wen
								  fmls
								  stack)
					   (evmeaning-push-vaargs name
								  code
								  wen
								  fmls
								  stack))))
			       (evmeaning (evmeaning-procedure-bcode fun) e2))
			    (begin
			       (set! *current-bcode* code)
			       (eval-apply name fun len (reverse! new))))
			(loop (cdr args)
			      (cons (evmeaning (car args) stack) new)
			      (+fx 1 len))))))
	     ;; This code is very sensitive to the compiler order. Because
	     ;; of tail recursion, it is extremely important that the capture
	     ;; variable are order 0 for the body (the variable !b), and 1
	     ;; for the stack (the variable !s). To enforce this order, we
	     ;; explicitly use a cascade of "if"s
	     ;; procedure arity 0, traced
	     ((bounce (code stack) (37))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda ()
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b !s)))
			      (c-pop-trace)
			      res))))
		  0
		  body
		  stack)))
	     ;; ...untraced
	     ((bounce (code stack) (42))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda ()
		     (let ((!b body))
			(evmeaning !b stack)))
		  0
		  body
		  stack)))
	     ;; procedure arity 1, traced
	     ((bounce (code stack) (38))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b (cons x !s))))
			      (c-pop-trace)
			      res))))
		  1
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (43))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x)
		     (let ((!b body))
			(evmeaning !b (cons x stack))))
		  1
		  body
		  stack)))
	     ;; procedure arity 2, traced
	     ((bounce (code stack) (39))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b (cons x (cons y !s)))))
			      (c-pop-trace)
			      res))))
		  2
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (44))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y stack)))))
		  2
		  body
		  stack)))
	     ;; procedure arity 3, traced
 	     ((bounce (code stack) (40))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b
						 (cons x
						       (cons y
							     (cons z !s))))))
			      (c-pop-trace)
			      res))))
		  3
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (45))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y (cons z stack))))))
		  3
		  body
		  stack)))
	     ;; procedure arity 4, traced
	     ((bounce (code stack) (41))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z t)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning
				       !b
				       (cons x
					     (cons y
						   (cons z
							 (cons t !s)))))))
			      (c-pop-trace)
			      res))))
		  4
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (46))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z t)
		     (let ((!b body))
			(evmeaning !b
				   (cons x (cons y (cons z (cons t stack)))))))
		  4
		  body
		  stack)))
	     ;; procedure arity -1, traced
	     ((bounce (code stack) (47))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda x
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b (cons x !s))))
			      (c-pop-trace)
			      res))))
		  -1
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (51))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda x
		     (let ((!b body))
			(evmeaning !b (cons x stack))))
		  -1
		  body
		  stack)))
	     ;; procedure arity -2, traced
	     ((bounce (code stack) (48))
	      (let ((body  (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x . y)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b (cons x (cons y !s)))))
			      (c-pop-trace)
			      res))))
		  -2
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (52))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x . y)
		     (let ((!b body))
			(evmeaning !b (cons x (cons y stack)))))
		  -2
		  body
		  stack)))
	     ;; procedure arity -3, traced
	     ((bounce (code stack) (49))
	      (let ((body (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y . z)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning !b
						 (cons x
						       (cons y
							     (cons z !s))))))
			      (c-pop-trace)
			      res))))
		  -3
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (53))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y . z)
		     (let ((!b body))
			(evmeaning !b
				   (cons x (cons y (cons z stack))))))
		  -3
		  body
		  stack)))
	     ;; procedure arity -4, traced
	     ((bounce (code stack) (50))
	      (let ((body  (evcode-ref code 0))
		    (where (evcode-ref code 1)))
		 (evmeaning-procedure!
		  (lambda (x y z . t)
		     (let ((!b body)
			   (!s stack))
			(let ()
			   (c-push-trace where)
			   (let ((res (evmeaning
				       !b
				       (cons x
					     (cons y
						   (cons z
							 (cons t
							       !s)))))))
			      (c-pop-trace)
			      res))))
		  -4
		  body
		  stack)))
	     ;; untraced
	     ((bounce (code stack) (54))
	      (let ((body (evcode-ref code 0)))
		 (evmeaning-procedure!
		  (lambda (x y z . t)
		     (let ((!b body))
			(evmeaning
			 !b
			 (cons x (cons y (cons z (cons t stack)))))))
		  -4
		  body
		  stack)))
	     ;; procedure arity > 4 arguments, traced
	     ((55)
	      (evmeaning-make-traced-4procedure code stack))
	     ;; untraced
	     ((56)
	      (evmeaning-make-4procedure code stack))
	     ((65)
	      ;; let (bindings are stored reversed!)
	      (let loop ((vals (evcode-ref code 1))
			 (env stack))
		 (if (null? vals)
		     (evmeaning (evcode-ref code 0) env)
		     (loop (cdr vals)
			   (cons (evmeaning (car vals) stack) env)))))
	     ((66)
	      ;; let*
	      (let loop ((vals (evcode-ref code 1))
			 (env stack))
		 (if (null? vals)
		     (evmeaning (evcode-ref code 0) env)
		     (loop (cdr vals)
			   (cons (evmeaning (car vals) env) env)))))
	     ((70)
	      ;; letrec
	      (let* ((vals (evcode-ref code 1))
		     (env2 (append (make-list (length vals)) stack)))
		 (let loop ((vals vals)
			    (env3 env2))
		    (if (null? vals)
			(evmeaning (evcode-ref code 0) env2)
			(begin
			   (set-car! env3 (evmeaning (car vals) env2))
			   (loop (cdr vals) (cdr env3)))))))
	     (else
	      ;; unknown byte code
	      (evmeaning-error code
			       "evmeaning (internal error)"
			       "unknown byte-code"
			       code))))
       code))

(emit-bounced!)

;*---------------------------------------------------------------------*/
;*    evprocedure ...                                                  */
;*---------------------------------------------------------------------*/
(define-struct evprocedure args bcode stack)

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure? ...                                         */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure? proc)
   (when (procedure? proc) (evprocedure? (%procedure-eval proc))))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure! ...                                         */
;*---------------------------------------------------------------------*/
(define (evmeaning-procedure! proc args bcode stack)
   (%procedure-eval-set! proc (evprocedure args bcode stack))
   proc)

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-bcode ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-bcode proc)
   (evprocedure-bcode (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-stack ...                                    */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-stack proc)
   (evprocedure-stack (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-procedure-args ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (evmeaning-procedure-args proc)
   (evprocedure-args (%procedure-eval proc)))

;*---------------------------------------------------------------------*/
;*    evmeaning-location ...                                           */
;*---------------------------------------------------------------------*/
(define (evmeaning-location)
   (if (evcode? *current-bcode*)
       (let ((p (evcode-loc *current-bcode*)))
	  (match-case p
	     ((at ?fname ?loc ?line)
	      p)
	     (else
	      #f)))
       #f))
   
;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-location ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-location o)
   (let ((bcode (list-ref *funcall-bcodes*
			  (- *funcall-bcode-length*
			     (modulo o *funcall-bcode-length*)))))
      (if (evcode? bcode)
	  (let ((p (evcode-loc bcode)))
	     (match-case p
		((at ?fname ?loc ?line)
		 p)
		(else
		 #f)))
	  #f)))
   
;*---------------------------------------------------------------------*/
;*      update-eval-global! ...                                        */
;*---------------------------------------------------------------------*/
(define (update-eval-global! variable val)
   (if (eq? (eval-global-tag variable) 1)
       (__evmeaning_address-set! (eval-global-value variable) val)
       (set-eval-global-value! variable val))
   (eval-global-name variable))

;*---------------------------------------------------------------------*/
;*    *funcall-bcodes* ...                                             */
;*---------------------------------------------------------------------*/
(define *funcall-bcode-length*
   (let ((std (getenv "BIGLOOSTACKDEPTH")))
      (if (number? std)
	  (max std 10)
	  10)))
(define *funcall-bcodes*
   (let ((l (make-list *funcall-bcode-length* #f)))
      (set-cdr! (last-pair l) l)
      l))


;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-0 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-0 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (error "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 0))
	  (error "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-0 fun)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-1 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-1 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (error "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 1))
	  (error "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-1 fun a0)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-2 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-2 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (error "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 2))
	  (error "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-2 fun a0 a1)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-3 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-3 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (error "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 3))
	  (error "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-3 fun a0 a1 a2)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-funcall-4 ...                                          */
;*---------------------------------------------------------------------*/
(define (evmeaning-funcall-4 code stack)
   (let* ((name (evcode-ref code 0))
	  (fun (evmeaning (evcode-ref code 1) stack))
	  (a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack))
	  (a3 (evmeaning (evcode-ref code 5) stack)))
      (set! *current-bcode* code)
      (cond
	 ((not (procedure? fun))
	  (error "eval" "Not a procedure" name))
	 ((not (correct-arity? fun 4))
	  (error "eval" "Wrong number of argument" name))
	 (else
	  (%funcall-4 fun a0 a1 a2 a3)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-0-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-0-stack code stack fun)
   (let* ((envd (evmeaning-procedure-stack fun))
	  (arity (evmeaning-procedure-args fun)))
      (case arity
	 ((0)
	  envd)
	 ((-1)
	  (cons '() envd))
	 (else
	  (evmeaning-arity-error code (evcode-ref code 0))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-1-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-1-stack code stack fun)
   (let ((a0 (evmeaning (evcode-ref code 2) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((1)
	     (cons a0 envd))
	    ((-1)
	     (cons (list a0) envd))
	    ((-2)
	     (cons a0 (cons '() envd)))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-2-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-2-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((2)
	     (cons a0 (cons a1 envd)))
	    ((-1)
	     (cons (list a0 a1) envd))
	    ((-2)
	     (cons a0 (cons (list a1) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons '() envd))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-3-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-3-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((3)
	     (cons a0 (cons a1 (cons a2 envd))))
	    ((-1)
	     (cons (list a0 a1 a2) envd))
	    ((-2)
	     (cons a0 (cons (list a1 a2) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons (list a2) envd))))
	    ((-4)
	     (cons a0 (cons a1 (cons a2 (cons '() envd)))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-tailcall-4-stack ...                                   */
;*---------------------------------------------------------------------*/
(define (evmeaning-tailcall-4-stack code stack fun)
   (let* ((a0 (evmeaning (evcode-ref code 2) stack))
	  (a1 (evmeaning (evcode-ref code 3) stack))
	  (a2 (evmeaning (evcode-ref code 4) stack))
	  (a3 (evmeaning (evcode-ref code 5) stack)))
      (let* ((envd (evmeaning-procedure-stack fun))
	     (arity (evmeaning-procedure-args fun)))
	 (case arity
	    ((4)
	     (cons a0 (cons a1 (cons a2 (cons a3 envd)))))
	    ((-1)
	     (cons (list a0 a1 a2 a3) envd))
	    ((-2)
	     (cons a0 (cons (list a1 a2 a3) envd)))
	    ((-3)
	     (cons a0 (cons a1 (cons (list a2 a3) envd))))
	    ((-4)
	     (cons a0 (cons a1 (cons a2 (cons (list a3) envd)))))
	    ((-5)
	     (cons a0 (cons a1 (cons a2 (cons a3 (cons '() envd))))))
	    (else
	     (evmeaning-arity-error code (evcode-ref code 0)))))))

;*---------------------------------------------------------------------*/
;*    eval-apply ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (eval-apply name fun len args)
   (cond
      ((not (procedure? fun))
       (error "apply" "Not a procedure" name))
      ((not (correct-arity? fun len))
       (error "eval" "Wrong number of argument" name))
      (else
       (%eval-apply fun args))))

;*---------------------------------------------------------------------*/
;*    evmeaning-make-traced-4procedure ...                             */
;*---------------------------------------------------------------------*/
(define (evmeaning-make-traced-4procedure code stack)
   (let ((body (evcode-ref code 0))
	 (where (evcode-ref code 1))
	 (formals (evcode-ref code 2)))
      (if (list? formals)
	  (let ((lf (length formals)))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ()
		       (c-push-trace where)
		       (let ((e2 (evmeaning-push-fxargs where code x lf !s)))
			  (let ((res (evmeaning !b e2)))
			     (c-pop-trace)
			     res)))))
	      lf
	      body
	      stack))
	  (let ((lf (let loop ((formals formals)
			       (num -1))
		       (if (pair? formals)
			   (loop (cdr formals) (-fx num 1))
			   num))))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ()
		       (c-push-trace where)
		       (let ((e2 (evmeaning-push-vaargs where code x lf !s)))
			  (let ((res (evmeaning !b e2)))
			     (c-pop-trace)
			     res)))))
	      lf
	      body
	      stack)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-make-4procedure ...                                    */
;*---------------------------------------------------------------------*/
(define (evmeaning-make-4procedure code stack)
   (let ((body (evcode-ref code 0))
	 (formals (evcode-ref code 1)))
      (if (list? formals)
	  (let ((lf (length formals)))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ((e2 (evmeaning-push-fxargs x code x lf !s)))
		       (evmeaning !b e2))))
	      lf
	      body
	      stack))
	  (let ((lf (let loop ((formals formals)
			       (num -1))
		       (if (pair? formals)
			   (loop (cdr formals) (-fx num 1))
			   num))))
	     (evmeaning-procedure!
	      (lambda x
		 (let ((!b body)
		       (!s stack))
		    (let ((e2 (evmeaning-push-vaargs x code x lf !s)))
		       (evmeaning !b e2))))
	      lf
	      body
	      stack)))))

;*---------------------------------------------------------------------*/
;*    evmeaning-push-fxargs ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-push-fxargs name code actuals num stack)
   (let _loop_ ((actuals actuals)
		(num num))
      (cond
	 ((=fx num 0)
	  (if (not (null? actuals))
	      (evmeaning-arity-error code name))
	      stack)
	 ((null? actuals)
	  (evmeaning-arity-error code name))
	 (else
	  (cons (car actuals)
		(_loop_ (cdr actuals) (-fx num 1)))))))

;*---------------------------------------------------------------------*/
;*    evmeaning-push-vaargs ...                                        */
;*---------------------------------------------------------------------*/
(define (evmeaning-push-vaargs name code actuals num stack)
   (let _loop_ ((actuals actuals)
		(num num))
      (cond
	 ((=fx num -1)
	  (cons actuals stack))
	 ((null? actuals)
	  (evmeaning-arity-error code name))
	 (else
	  (cons (car actuals)
		(_loop_ (cdr actuals) (+fx num 1)))))))
   
;*---------------------------------------------------------------------*/
;*    Les environments ...                                             */
;*---------------------------------------------------------------------*/
(init-the-global-environment!)
       

