;; Compile a node only for side effect.
(module jvm_effect
   (import type_type ast_var ast_node
	   object_class      ; tclass
	   jvm_env jvm_instr jvm_expr jvm_compiler )
   (export (generic compile-effect e::node env::env)) )

;; When we don't know how to do the job.
(define (default e::node env::env)
   (compile-expr e env)
   (_pop env (compile-type e env)) )

(define-generic (compile-effect e::node env::env))

(define-method (compile-effect e::atom env::env)
   'ok )

(define-method (compile-effect e::var env::env)
   'ok )

(define-method (compile-effect e::let-var env::env)
   (compiler-let e env compile-effect) )

(define-method (compile-effect e::setq env::env)
   (compiler-setq e env) )

(define-method (compile-effect e::sequence env::env)
   (compiler-sequence e env compile-effect) )

(define-method (compile-effect e::conditional env::env)
   (compiler-if e env compile-effect) )

(define-method (compile-effect e::select env::env)
   (compiler-select e env compile-effect) )

(define-method (compile-effect e::let-fun env::env)
   (compiler-labels e env compile-effect) )

(define-method (compile-effect e::app env::env)
   ;; CARE here we can do a special-inline-effect
   (default e env) )

(define-method (compile-effect e::app-ly env::env)
   (default e env) )

(define-method (compile-effect e::funcall env::env)
   (default e env) )

(define-method (compile-effect e::pragma env::env)
   (default e env) )

(define-method (compile-effect e::getfield env::env)
   (compile-effect (car (getfield-expr* e)) env) )

(define-method (compile-effect e::setfield env::env)
   (compiler-setfield e env) )

(define-method (compile-effect e::new env::env)
   'ok )

(define-method (compile-effect e::valloc env::env)
   (compile-effect (car (valloc-expr* e)) env) )

(define-method (compile-effect e::vref env::env)
   (with-access::vref e (expr*)
      (compile-effect (car expr*) env)
      (compile-effect (cadr expr*) env) ))

(define-method (compile-effect e::vset! env::env)
   (compiler-vset e env) )

(define-method (compile-effect e::vlength env::env)
   (compile-effect (car (vlength-expr* e)) env) )

(define-method (compile-effect e::isa env::env)
   (compile-effect (car (isa-expr* e)) env) )

(define-method (compile-effect e::cast-null env::env)
   (default e env) )

(define-method (compile-effect e::cast env::env)
   (compiler-cast e env compile-effect) )

(define-method (compile-effect e::set-ex-it env::env)
   (default e env) )

(define-method (compile-effect e::jump-ex-it env::env)
   (default e env) )

(define-method (compile-effect e::fail env::env)
   (default e env) )

(define-method (compile-effect e::make-box env::env)
   (compile-effect (make-box-value e) env) )

(define-method (compile-effect e::box-ref env::env)
   'ok )

(define-method (compile-effect e::box-set! env::env)
   (compiler-box-set! e env) )
