/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include <libgen.h>
#include <glib.h>
#include <config.h>
#include "splashscreen.h"
#include "gwrappers.h"
#include "directories.h"


#define BIBLEDIT_SPLASH "bibledit.splash"
#define KILLALL "killall"


SplashScreen::SplashScreen (int dummy)
{
  current_information = "Bibledit";
  current_percentage = 0;
  ustring command = BIBLEDIT_SPLASH;
  command.append (" &"); // Runs in background.
  system (command.c_str());
  set_values ();
}


SplashScreen::~SplashScreen ()
{
  current_percentage = 100;
  set_values ();
}


void SplashScreen::percentage (int percentage)
{
  current_percentage = percentage;
  set_values ();
}


void SplashScreen::information (const ustring& information)
{
  current_information = information;
  set_values ();
}


void SplashScreen::set_values ()
{
  ustring filename = gw_build_filename (directories_get_temp(), "bibledit.splash");
  WriteText wt (filename);
  wt.text (convert_to_string (current_percentage) + " " + current_information);
}
