/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_FILEIO_H_
#define HTTPCACHE_FILEIO_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractFileIO.h"
#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "FileHandle.h"

namespace HttpCache
{

class LimitedSpaceObject;

class FileIO : public AbstractFileIO
{
	DECLARE_NON_COPYABLE(FileIO)
public:
	FileIO(FileHandle& file_handle,
		IntrusivePtr<LimitedSpaceObject> const& limited_object);
	
	virtual ~FileIO();
	
	virtual ssize_t read(void* buf, size_t len);
	
	virtual size_t read_n(void* buf, size_t len, ssize_t* last_result = 0);
	
	virtual ssize_t write(void const* buf, size_t len);
	
	virtual size_t write_n(void const* buf, size_t len);
	
	virtual off_t seek(off_t offset, int whence);
	
	virtual off_t tell();
	
	virtual int truncate(off_t len);
private:
	off_t m_curPos;
	IntrusivePtr<LimitedSpaceObject> m_ptrLimitedObject;
	FileHandle m_handle;
};

} // namespace HttpCache

#endif
