/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVERCONNECTION_H_
#define SERVERCONNECTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ConnectionRoute.h"
#include "HttpVersion.h"
#include "AutoClosingSAP.h"
#include <ace/config-lite.h>
#include <ace/SOCK_Stream.h>

class ServerConnection
{
public:
	ServerConnection(
		ConnectionRoute const& route,
		AutoClosingSAP<ACE_SOCK_Stream>& peer);
	
	~ServerConnection();
	
	ACE_SOCK_Stream const& peer() const { return m_peer; }
	
	ConnectionRoute const& getRoute() { return m_route; }
	
	bool isExpectedToPersist() const { return m_willPersist; }
	
	void toBeClosed() { m_willPersist = false; }
	
	int getNumResponses() const { return m_numResponses; }
	
	HttpVersion const& getMinResponseVersion() const { return m_minResponseVersion; }
	
	HttpVersion const& getMaxResponseVersion() const { return m_maxResponseVersion; }
	
	void registerResponse(HttpVersion const& version);
	
	void setTcpNoDelay(bool value = true);
private:
	ConnectionRoute m_route;
	AutoClosingSAP<ACE_SOCK_Stream> m_peer;
	bool m_willPersist;
	int m_numResponses;
	HttpVersion m_minResponseVersion;
	HttpVersion m_maxResponseVersion;
};

#endif
