/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FlashContentIdentifier.h"
#include "FlashResponseFilter.h"
#include "SplittableBuffer.h"

using namespace std;

FlashContentIdentifier::Status
FlashContentIdentifier::identify(SplittableBuffer const& data) const
{
	static char const SIG_FWS[] = {'F','W','S'};
	static char const SIG_CWS[] = {'C','W','S'};
	
	Status status = checkSignature(data, SIG_FWS, SIG_FWS+sizeof(SIG_FWS));
	if (status != NO_MATCH) {
		return status;
	}
	return checkSignature(data, SIG_CWS, SIG_CWS+sizeof(SIG_CWS));
}

std::auto_ptr<AbstractResponseFilter>
FlashContentIdentifier::getFilter(ResponseFilterChain& chain, bool ignore_size) const
{
	return std::auto_ptr<AbstractResponseFilter>(
		new FlashResponseFilter(chain, ignore_size)
	);
}
