# - Locate the wxWidgets library
# This module defines
#  WX_FOUND -- true if ACE was found
#  WX_LIB_DIR -- directory where wx libraries are located
#  WX_INCLUDE_DIR -- path to wx/wx.h
#  WX_LIB_SUFFIX -- library version suffix, like "26" or "28"
MACRO(BF_FIND_WX)
	GET_FILENAME_COMPONENT(parent_dir_ "${PROJECT_SOURCE_DIR}/.." ABSOLUTE)
	FILE(GLOB wx_dirs_ "${parent_dir_}/wxMSW-2.*.*[0-9]")
	FIND_PATH(
		WX_INCLUDE_DIR wx/wx.h
		PATHS ${wx_dirs_}
		PATH_SUFFIXES include
		DOC "Path to wx/wx.h"
	)
	FIND_PATH(
		WX_LIB_DIR wxpng.lib
		PATHS ${wx_dirs_}
		PATH_SUFFIXES "lib/vc_lib"
		DOC "Path to wx libraries"
	)
	IF(WX_INCLUDE_DIR AND WX_LIB_DIR)
		SET(WX_FOUND TRUE)
		FILE(GLOB wxbase_libs_ "${WX_LIB_DIR}/wxbase*[0-9].lib")
		FOREACH(lib_ ${wxbase_libs_})
			STRING(REGEX REPLACE ".*wxbase(.*).lib" "\\1" WX_LIB_SUFFIX "${lib_}")
		ENDFOREACH(lib_)
	ELSE(WX_INCLUDE_DIR AND WX_LIB_DIR)
		SET(WX_FOUND FALSE)
	ENDIF(WX_INCLUDE_DIR AND WX_LIB_DIR)
ENDMACRO(BF_FIND_WX)
