/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TYPES_H_
#define TYPES_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if defined(HAVE_STDINT_H)
#  include <stdint.h>
#elif defined(HAVE_INTTYPES_H)
#  include <inttypes.h>
#else

#include <limits.h>

#if UCHAR_MAX == 0xff
typedef signed char int8_t;
typedef signed char int_least8_t;
typedef signed char int_fast8_t;
typedef unsigned char uint8_t;
typedef unsigned char uint_least8_t;
typedef unsigned char uint_fast8_t;
#else
#error no 8 bit types found!
#endif

#if USHRT_MAX == 0xffff
typedef short int16_t;
typedef short int_least16_t;
typedef short int_fast16_t;
typedef unsigned short uint16_t;
typedef unsigned short uint_least16_t;
typedef unsigned short uint_fast16_t;
#elif UINT_MAX == 0xffff
typedef int int16_t;
typedef int int_least16_t;
typedef int int_fast16_t;
typedef unsigned int uint16_t;
typedef unsigned int uint_least16_t;
typedef unsigned int uint_fast16_t;
#else
#error no 16 bit types found!
#endif

#if UINT_MAX == 0xffffffff
typedef int int32_t;
typedef int int_least32_t;
typedef int int_fast32_t;
typedef unsigned int uint32_t;
typedef unsigned int uint_least32_t;
typedef unsigned int uint_fast32_t;
#elif ULONG_MAX == 0xffffffff
typedef long int32_t;
typedef long int_least32_t;
typedef long int_fast32_t;
typedef unsigned long uint32_t;
typedef unsigned long uint_least32_t;
typedef unsigned long uint_fast32_t;
#else
#error no 32 bit types found!
#endif

#if ULONG_MAX == 18446744073709551615U // 2^64 - 1
typedef long int64_t;
typedef long int_least64_t;
typedef long int_fast64_t;
typedef unsigned long uint64_t;
typedef unsigned long uint_least64_t;
typedef unsigned long uint_fast64_t;
typedef long intmax_t;
typedef unsigned long uintmax_t;
#elif defined(UI64_MAX)
typedef __int64 int64_t;
typedef __int64 int_least64_t;
typedef __int64 int_fast64_t;
typedef unsigned __int64 uint64_t;
typedef unsigned __int64 uint_least64_t;
typedef unsigned __int64 uint_fast64_t;
typedef __int64 intmax_t;
typedef unsigned __int64 uintmax_t;
#elif defined(ULLONG_MAX) || defined(ULONG_LONG_MAX) || defined(ULONGLONG_MAX)
typedef long long int64_t;
typedef long long int_least64_t;
typedef long long int_fast64_t;
typedef unsigned long long uint64_t;
typedef unsigned long long uint_least64_t;
typedef unsigned long long uint_fast64_t;
typedef long long intmax_t;
typedef unsigned long long uintmax_t;
#else
typedef int32_t intmax_t;
typedef uint32_t uintmax_t;
#endif

#endif /* HAVE_STDINT_H */

#endif /* TYPES_H_ */
