/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PROXYWATCHER_H_
#define PROXYWATCHER_H_

#include <SystemConfiguration/SystemConfiguration.h>
#include <CoreFoundation/CoreFoundation.h>
#include "NonCopyable.h"
#include "RefPtr.h"
#include "OutputFunction.h"
#include <string>
#include <utility>

class NetworkPrefs;

class ProxyWatcher
{
	DECLARE_NON_COPYABLE(ProxyWatcher)
public:
	ProxyWatcher(
		StringRef const& client_name,
		RefPtr<CFRunLoopRef> const& run_loop);
	
	~ProxyWatcher();
	
	void updateProxies();
private:
	class GenericError;
	
	typedef std::pair<StringRef, StringRef> StringPair;
	
	static void storeModifiedCallback(
		SCDynamicStoreRef store, CFArrayRef changedKeys, void* info);
	
	void getProxiesFromPersistentStore(StringRef const& primary_service);
	
	static StringRef getServiceDeviceName(
		NetworkPrefs& prefs, StringRef const& service_path);
	
	static StringPair findSetReferencingService(
		NetworkPrefs& prefs, StringRef const& service_path);
	
	static StringPair getCurrentSet(NetworkPrefs& prefs);
	
	static StringRef findSetByName(NetworkPrefs& prefs, StringRef const& name);
	
	static StringRef findServiceBySetAndDeviceName(
		NetworkPrefs& prefs, StringRef const& set_id, StringRef const& device_name);
	
	static void getProxiesFromService(DictRef const& service);
	
	static bool isProxyEnabled(
		DictRef const& proxies, CFStringRef key);
	
	static void processHttpProxy(DictRef const& proxies);
	
	static void processSocksProxy(DictRef const& proxies);
	
	static void processProxyAutoDiscovery(DictRef const& proxies);
	
	static void processProxyAutoConfig(DictRef const& proxies);
	
	static void readProxySkipList(
		DictRef const& proxies, OutputFunction<std::string>& output);
	
	static void setNoProxy();
	
	static void setGenericError(std::string const& msg);
	
	RefPtr<SCDynamicStoreRef> m_ptrStore;
	StringRef m_ptrClientName;
	RefPtr<CFRunLoopRef> m_ptrRunLoop;
	RefPtr<CFRunLoopSourceRef> m_ptrRunLoopSource;
	StringRef m_ptrNetworkStateKey;
	StringRef m_ptrProxiesStateKey;
	CFStringRef m_bfPrefix;
};

#endif
