/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef BASICCONFIGDIALOG_H_
#define BASICCONFIGDIALOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ProxyDescriptor.h"
#include <wx/dialog.h>

class wxWindow;
class wxCommandEvent;
class wxCloseEvent;
class wxString;
class wxTextCtrl;
class wxCheckBox;
class wxChoice;
class Config;

class BasicConfigDialog : public wxDialog
{
public:
	BasicConfigDialog();
	
	~BasicConfigDialog();
	
	static void show();
private:
	struct ProxyOption;
	
	void onWindowClose(wxCloseEvent& evt);
	
	void onProxyTypeChanged(wxCommandEvent& evt);
	
	void onProxyTypeChanged(ProxyDescriptor::ProxyType type);
	
	ProxyDescriptor::ProxyType getProxyType() const;
	
	void setProxyType(ProxyDescriptor::ProxyType type);
	
	void loadConfig();
	
	void setCurrentListenPort(wxString const& port);
	
	void onApply(wxCommandEvent& evt);
	
	bool restoreOldConfig(Config const& config);
	
	void showError(wxString const& msg);
	
	void showWarning(wxString const& msg);
	
	static BasicConfigDialog* m_spInstance;
	static ProxyOption const m_sProxyOptions[];
	wxString m_curListenPort;
	wxTextCtrl* m_pListenPort;
	wxCheckBox* m_pTrayAnimation;
	wxChoice* m_pProxyType;
	wxTextCtrl* m_pProxyHost;
	wxTextCtrl* m_pProxyPort;
	wxTextCtrl* m_pProxyUser;
	wxTextCtrl* m_pProxyPass;
	DECLARE_EVENT_TABLE()
};

#endif
