/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ContentFilterGroup.h"
#include <algorithm>

using namespace std;

ContentFilterGroup::ContentFilterGroup(
	FilterGroupTag const& tag, std::string const& fname, FileLocation loc)
:	m_tag(tag),
	m_fileName(fname),
	m_fileLocation(loc)
{
}

ContentFilterGroup::~ContentFilterGroup()
{
}

void
ContentFilterGroup::swap(ContentFilterGroup& other)
{
	m_tag.swap(other.m_tag);
	m_fileName.swap(other.m_fileName);
	std::swap(m_fileLocation, other.m_fileLocation);
	m_fileStructure.swap(other.m_fileStructure);
	m_filters.swap(other.m_filters);
}
