/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef STATE_H_
#define STATE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Conf.h"
#include "CombinedUrlPatterns.h"
#include "ContentFilters.h"

class State
{
public:
	State();
	
	~State();
	
	// member-wise copying is OK
	
	Config& config() { return m_config; }
	
	Config const& config() const { return m_config; }
	
	CombinedUrlPatterns& urlPatterns() { return m_urlPatterns; }
	
	CombinedUrlPatterns const& urlPatterns() const { return m_urlPatterns; }
	
	ContentFilters& contentFilters() { return m_contentFilters; }
	
	ContentFilters const& contentFilters() const { return m_contentFilters; }
	
	bool isFilteringEnabled() const { return m_isFilteringEnabled; }
	
	void setFilteringEnabled(bool val) { m_isFilteringEnabled = val; }
private:
	Config m_config;
	CombinedUrlPatterns m_urlPatterns;
	ContentFilters m_contentFilters;
	bool m_isFilteringEnabled;
};

#endif
