/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SocksError.h"

char const*
SocksError::toString() const
{
	switch (m_code) {
		case GENERIC_ERROR:
		return "generic error on the client side";
		case CONNECTION_CLOSED:
		return "connection closed by socks server";
		case PROTOCOL_VIOLATION:
		return "protocol violation on the part of socks server";
		case SOCKS_SERVER_FAILURE:
		return "generic error on the server side";
		case SOCKS_SERVER_TIMEOUT:
		return "socks server timeout";
		case UNSUPPORTED_AUTH_METHOD:
		return "authentication method not supported by socks server";
		case UNSUPPORTED_ADDRESS_TYPE:
		return "address type not supported by socks server";
		case UNSUPPORTED_COMMAND:
		return "command not supported by socks server";
		case AUTH_REQUIRED:
		return "authentication required";
		case AUTH_FAILURE:
		return "authentication failure";
		case FORBIDDEN_BY_RULESET:
		return "request is forbidden by socks server rule set";
		case REJECTED_OR_FAILED:
		return "request rejected or failed";
		case DESTINATION_UNREACHABLE:
		return "destination unreachable";
		case CONNECTION_REFUSED:
		return "connection refused";
		case LOCAL_DNS_FAILED:
		return "name resolution (done locally) failed";
	}
	return "unrecognized error code";
}
