/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKS5REQUESTER_H_
#define SOCKS5REQUESTER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Observer.h"
#include "AsyncReaderWriter.h"
#include "SocksError.h"
#include <ace/config-lite.h>
#include <string>
#include <vector>

class Reactor;
class SymbolicInetAddr;

class Socks5Requester : private AsyncReaderWriter::Listener
{
	DECLARE_NON_COPYABLE(Socks5Requester)
public:
	class Listener;
	
	Socks5Requester();
	
	virtual ~Socks5Requester();
	
	void requestConnection(
		Listener& listener, Reactor& reactor, ACE_HANDLE handle,
		SymbolicInetAddr const& addr);
	
	void abort();
	
	bool isInProgress() const { return m_state != ST_INACTIVE; }
private:
	enum State {
		ST_INACTIVE,
		ST_SENDING_REQUEST,
		ST_RECEIVING_PARTIAL_RESPONSE,
		ST_RECEIVING_REST_OF_RESPONSE
	};
	
	virtual void onReadDone();
	
	virtual void onReadError();
	
	virtual void onWriteDone();
	
	virtual void onWriteError();
	
	virtual void onGenericError();
	
	void onPartialResponseReceived();
	
	void onFullResponseReceived();
	
	void handleRequestFailure(SocksError::Code code);
	
	void handleRequestSuccess();
	
	static SocksError::Code socksStatusToErrorCode(unsigned char status);
	
	static std::vector<unsigned char> createConnectMsg(
		SymbolicInetAddr const& addr);
	
	State m_state;
	SingleObserverLink<Listener> m_observerLink;
	AsyncReaderWriter m_readerWriter;
	std::vector<unsigned char> m_msgConnect;
	std::vector<unsigned char> m_response;
};


class Socks5Requester::Listener : public ObserverBase
{
public:
	virtual ~Listener() {}
	
	virtual void onRequestSuccess() = 0;
	
	virtual void onRequestFailure(SocksError const& err) = 0;
};

#endif
