/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef JSENVPROXY_H_
#define JSENVPROXY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SharedPtr.h"
#include "URI.h"

class JsEnvironment;

/*
This class is not thread-safe.
Concurrent access from different threads to the same instance is not allowed.
*/
class JsEnvProxy
{
public:
	JsEnvProxy();
	
	JsEnvProxy(JsEnvProxy const& other); // share the environment
	
	~JsEnvProxy();
	
	JsEnvironment* operator->() { return access(); }
	
	JsEnvironment& operator*() { return *access(); }
	
	void setPageURL(URI const& url);
	
	void reset();
private:
	void operator=(JsEnvProxy const&); // forbidden
	
	JsEnvironment* access();
	
	SharedPtr<JsEnvironment, ACE_NULL_SYNCH> m_ptrEnv;
	URI m_pageURL;
};

#endif
