/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AdSuspect.h"
#include "BString.h"
#include "SplittableBuffer.h"
#include "SBOutStream.h"
#include "HeuristicScore.h"
#include "InsensitiveEqual.h"
#include "URI.h"
#include <ostream>
#include <algorithm>

using namespace std;

auto_ptr<SplittableBuffer>
AdSuspect::getHtmlSubstitution() const
{
	SBOutStream strm;
	writeSubstitution(strm);
	auto_ptr<SplittableBuffer> res(new SplittableBuffer);
	strm.swapData(*res);
	return res;
}

auto_ptr<SplittableBuffer>
AdSuspect::getJsSubstitution() const
{
	// TODO: need to properly escape the js literal
	SBOutStream strm;
	strm << "<!--\r\ndocument.write('";
	writeSubstitution(strm);
	strm << "');\r\n// -->";
	auto_ptr<SplittableBuffer> res(new SplittableBuffer);
	strm.swapData(*res);
	return res;
}

BString
AdSuspect::getSubstitutionURL(
	char const* prefix, URI const& orig_url,
	int width, int height)
{
	if (width < 1) {
		width = 15;
	}
	if (height < 1) {
		height = 15;
	}
	
	if (!orig_url.getScheme().empty() &&
	    !InsensitiveEqual()(orig_url.getScheme(), BString("http"))) {
		SBOutStream buf(20);
		buf << '/' << prefix << width << 'x' << height << '/';
		return buf.data().toBString();
	}
	
	SBOutStream new_path(100);
	new_path << prefix << width << 'x' << height << '/' << orig_url.getRawPath();
	URI subst_url(orig_url);
	subst_url.setAbsoluteRawPath(new_path.data().toBString());
	return subst_url.toBString();
}

BString
AdSuspect::getAnalyzeURL(
	URI const& orig_url, bool ignore_size)
{
	SBOutStream new_path(100);
	if (ignore_size) {
		new_path << BString("bf-analyze-is");
	} else {
		new_path << BString("bf-analyze");
	}
	new_path << '/' << orig_url.getRawPath();
	URI subst_url(orig_url);
	subst_url.setAbsoluteRawPath(new_path.data().toBString());
	return subst_url.toBString();
}

BString
AdSuspect::getAnalyzeURL(
	URI const& orig_url, HeuristicScore const& score)
{
	return getAnalyzeURL(orig_url, score.getNumericSizeScore() != 0);
}
