/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaUnion.h"

NfaUnion::NfaUnion(Nfa const& first)
:	m_length(first.length())
{
	m_states.reserve(2 + first.statesEnd() - first.statesBegin());
	m_states.insert(m_states.end(), 2, NfaState());
	addComponent(first);
}

NfaUnion::NfaUnion(Nfa const& first, Nfa const& second)
:	m_length(first.length())
{
	m_states.reserve(2 + first.statesEnd() - first.statesBegin());
	m_states.insert(m_states.end(), 2, NfaState());
	addComponent(first);
	addComponent(second);
}

NfaUnion::~NfaUnion()
{
}

NfaUnion&
NfaUnion::addComponent(Nfa const& component)
{
	int base = m_states.size();
	m_states.insert(m_states.end(), component.statesBegin(), component.statesEnd());
	m_states[0].addEpsilonTransition(base + component.getStartPos());
	int finish = base + component.getFinishPos();
	m_states[finish].addEpsilonTransition(1 - finish);
	if (m_length != component.length()) {
		m_length = -1;
	}
	return *this;
}

int
NfaUnion::length() const
{
	return m_length;
}

NfaState const*
NfaUnion::statesBegin() const
{
	return &m_states[0];
}

NfaState const*
NfaUnion::statesEnd() const
{
	return &m_states[m_states.size()];
}

int
NfaUnion::getStartPos() const
{
	return 0;
}

int
NfaUnion::getFinishPos() const
{
	return 1;
}
