/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaState.h"

NfaState::NfaState()
:	m_defaultSymbolTransition(NO_TRANSITION)
{
}

NfaState::~NfaState()
{
}

NfaState::NextStateOffset
NfaState::getSymbolTransition(uint8_t symbol) const
{
	std::map<uint8_t, NextStateOffset>::const_iterator fit = m_symbolTransitions.find(symbol);
	if (fit != m_symbolTransitions.end()) {
		return fit->second;
	}
	return m_defaultSymbolTransition;
}

void
NfaState::setSymbolTransition(uint8_t symbol, NextStateOffset target)
{
    m_symbolTransitions[symbol] = target;
}

void
NfaState::setDefaultSymbolTransition(NextStateOffset target)
{
    m_defaultSymbolTransition = target;
}

void
NfaState::addEpsilonTransition(NextStateOffset target)
{
    m_epsilonTransitions.insert(target);
}

void
NfaState::removeEpsilonTransition(NextStateOffset target)
{
    m_epsilonTransitions.erase(target);
}
