/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TAG_H_
#define TAG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"

/*
Basically an auto-creating IntrusivePtr with a reduced interface.
Can be used as a typed unique identifier, optionally carrying additional data.
*/
template<typename T>
class Tag
{
public:
	Tag() : m_ptrObj(new T) {}
	
	// Default copy ctor and assignment operator OK
	
	template<typename OT> Tag(Tag<OT> const& other) : m_ptrObj(other) {}
protected:
	explicit Tag(T* obj) : m_ptrObj(obj) {}
public:
	T& operator*() const { return *m_ptrObj; }
	
	T* operator->() const { return m_ptrObj.get(); }
	
	operator T*() const { return m_ptrObj.get(); }
	
	void swap(Tag& other) { m_ptrObj.swap(other.m_ptrObj); }
private:
	IntrusivePtr<T> m_ptrObj;
};


template<typename T>
void swap(Tag<T>& lhs, Tag<T>& rhs)
{
	lhs.swap(rhs);
}

#endif
