/**
 *
 * Beryl Inter-Plugin-Communication-System
 *
 * Copyright : (C) 2006 by Dennis Kasprzyk
 * E-mail    : onestone@beryl-project.org
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 **/

#ifndef BERYL_IPCS_H_
#define BERYL_IPCS_H_

// *************************************
// * defines                           *
// *************************************

//
//    These defines represent the first bit position and type of the value in the ipcs data array
//
//    Following data types are defined:
//          IPCS_BOOL   = boolean (Bool)
//          IPCS_UCHAR  = unsigned char (UChar)
//          IPCS_INT    = signed integer (Int)
//          IPCS_CHAR   = signed char (Char)
//          IPSC_UINT   = unsigned int (UInt)
//          IPSC_SHORT  = short (Short)
//          IPSC_USHORT = unsigned short (UShort)
//          IPSC_LONG   = signed long (Long)
//          IPSC_ULONG  = unsigned long (ULong)
//          IPCS_FLOAT  = float (Float)
//          IPCS_DOUBLE = double (Double)
//          IPCS_CPTR   = char * (CPtr)
//          IPCS_VPTR   = void * (VPtr)
//
//    Values are stored as a combination of a boolean isSet value and the bytes needed to store the data type
//    IPCS does not free pointer data types
//

#define IPCS_BOOL   0
#define IPCS_UCHAR  1
#define IPCS_INT    2
#define IPCS_CHAR   3
#define IPCS_UINT   4
#define IPCS_SHORT  5
#define IPCS_USHORT 6
#define IPCS_LONG   7
#define IPCS_ULONG  8
#define IPCS_FLOAT  9
#define IPCS_DOUBLE 10
#define IPCS_CPTR   11
#define IPCS_VPTR   12

typedef struct _IPCS_Type
{
    char * name; // for reference
    int    size; // length
} IPCS_Type;
typedef struct _IPCS_Atom
{
    char * name; // \0 terminated name
    int    pos;  // position in data array
    int    type; // index in IPCS_Type array IPCSTypes
} IPCS_Atom;



// *************************************
// * functions                         *
// *************************************
#define IPCS_OBJ  unsigned int *size,unsigned char **data,unsigned int *atom_count,IPCS_Atom **atoms
#define IPCS_OBJNAMES size, data, atom_count, atoms

#define IPCS_MEMBERS unsigned int ipcs_size;        \
                     unsigned char *ipcs_data;      \
                     unsigned int ipcs_atom_count;  \
                     IPCS_Atom    *ipcs_atoms

#define IPCS_OBJECT(x) &((x)->ipcs_size),&((x)->ipcs_data),&((x)->ipcs_atom_count),&((x)->ipcs_atoms)
#define IPCS_FREEOBJ(x) if ((x)->ipcs_data) free((x)->ipcs_data);\
    if ((x)->ipcs_atoms) free((x)->ipcs_atoms)
#define IPCS_INITOBJ(x) (x)->ipcs_size=0; (x)->ipcs_data=NULL;\
    (x)->ipcs_atom_count=0; (x)->ipcs_atoms=NULL

#define IPCS_GEN_PROTOTYPES(ctype,itype)                                   \
    void IPCS_Set ## itype (IPCS_OBJ,int valueAtom, ctype value);          \
    void IPCS_Set ## itype ## N (IPCS_OBJ,char * name, ctype value);       \
    ctype IPCS_Get ## itype (IPCS_OBJ,int valueAtom);                      \
    ctype IPCS_Get ## itype ## N (IPCS_OBJ,char * name);                   \
    ctype IPCS_Get ## itype ## D (IPCS_OBJ,int valueAtom, ctype def);      \
    ctype IPCS_Get ## itype ## ND (IPCS_OBJ,char * name , ctype def);      \


// lease a valueAtom (optionally)
int IPCS_GetType(char * type);
int IPCS_GetAtom(IPCS_OBJ,int type,char * name,Bool create);

// is the value set?
Bool IPCS_IsSet(IPCS_OBJ,int valueAtom);
Bool IPCS_IsSetN(IPCS_OBJ,int type,char * name);

// unset the value
void IPCS_Unset(IPCS_OBJ,int valueAtom);
void IPCS_UnsetN(IPCS_OBJ,int type,char * name);

//
// following functions are provided (Int is used as example here):
//
// set values functions (setting of values is disabled during painting);
//
// void IPCS_SetInt(IPCS_OBJECT(x),int valueAtom,int value);
// void IPCA_SetIntN(IPCS_OBJECT(x),char * name, int value);
//
// get value functions
//
// int IPCS_GetInt(IPCS_OBJECT(x),int valueAtom);
// int IPCS_GetIntN(IPCS_OBJECT(x),char * name);
// int IPCS_GetIntD(IPCS_OBJECT(x),int valueAtom,int default);
// int IPCS_GetIntND(IPCS_OBJECT(x),char * name,int default);
//
// all functions with a N at the end do not create a atom
// all functions with a D at the end return default instead of 0 if the atom is not created or not set

IPCS_GEN_PROTOTYPES(Bool,Bool)
IPCS_GEN_PROTOTYPES(unsigned char,UChar)
IPCS_GEN_PROTOTYPES(int,Int)
IPCS_GEN_PROTOTYPES(char,Char)
IPCS_GEN_PROTOTYPES(unsigned int,UInt)
IPCS_GEN_PROTOTYPES(short,Short)
IPCS_GEN_PROTOTYPES(unsigned short,UShort)
IPCS_GEN_PROTOTYPES(long,Long)
IPCS_GEN_PROTOTYPES(unsigned long,ULong)
IPCS_GEN_PROTOTYPES(float,Float)
IPCS_GEN_PROTOTYPES(double,Double)
IPCS_GEN_PROTOTYPES(char *,CPtr)
IPCS_GEN_PROTOTYPES(void *,VPtr)

#endif
