/*
 *
 * Beryl hardware/software detection system
 *
 * Copyright : (C) 2006 by Quinn Storm
 * E-mail    : quinn@beryl-project.org
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef BERYL_SETTINGS_BACKEND
#define BERYL_SETTINGS_BACKEND
#include <beryl-settings.h>
gboolean backend_init (BerylSettingsContext * context);
gboolean backend_fini (BerylSettingsContext * context);
gboolean read_init (BerylSettingsContext * context);
void read_done (BerylSettingsContext * context);
gboolean write_init (BerylSettingsContext * context);
void write_done (BerylSettingsContext * context);
void read_setting(BerylSettingsContext * context, BerylSetting * setting);
void write_setting(BerylSettingsContext * context, BerylSetting * setting);
gboolean get_setting_is_integrated(BerylSetting * setting);
gboolean get_setting_is_read_only(BerylSetting * setting);
GSList * get_existing_profiles(void);
const gchar * get_short_desc(void);
gboolean get_supports_integration(void);
gboolean delete_profile(gchar *);
#endif
