// ServerMessageReceiver.cpp: implementation of the CServerMessageReceiver class.
//
//////////////////////////////////////////////////////////////////////

#include "ServerMessageReceiver.h"
#include <string.h>
#include "Comm/Connection_Mono.h" 
#include "Comm/Message.h" 
#include "Comm/MessageStack.h"

extern CConnection *gpConnectionClient;
extern BOOL gbServerMode;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CServerMessageReceiver::CServerMessageReceiver()
{
	m_pReceiveStack = NULL;
	m_pConnection = NULL;
}

CServerMessageReceiver::~CServerMessageReceiver()
{

}

void CServerMessageReceiver::SetConnection (CConnection *pConnection)
{
	if (pConnection == NULL)
	{
		return;
	}

	m_pConnection = (CConnection_Mono *)pConnection;
	m_pReceiveStack = m_pConnection->GetReceiveStack();
}

void CServerMessageReceiver::Tick ()
{
	if (m_pConnection == NULL || m_pReceiveStack == NULL)
	{
		return;
	}

	if (m_pReceiveStack->IsMessageAvailable())
	{
		CMessage *pMessage = m_pReceiveStack->GetMessage();

		if (pMessage == NULL)
		{
			return;
		}

		if (strcmp (pMessage->GetName (), "ConnectionMessage_Break") == 0)
		{
			// Stop Client connection
            m_pConnection->Stop();
            m_pConnection->Close();
			m_pConnection = NULL;
            gbServerMode = FALSE;

            // Connection broken, notify the user
			//MessageBox (NULL,"Connection Broken, please restart the application",gszTitle,MB_ICONEXCLAMATION | MB_OK);
		}
		else
		{
			// Put the message back to the stack
			m_pReceiveStack->PutMessage (pMessage);
		}
	}
}
