/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2003 Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* fixme: lots of duplicate code .. */

#include "pkcs11-lowlevel.h"

static CK_SESSION_HANDLE session;
static int errors = 0;

static int find_obj(CK_SESSION_HANDLE sess, CK_OBJECT_CLASS cls, CK_OBJECT_HANDLE_PTR p);
static void initialize(void);
static void hexdump(const char *msg, const unsigned char *inp, int len);

static void test_cat1(void);
static void test_cat2(void);
static void test1_1(void);
static void test1_2(void);
static void test1_3(void);
static void test1_4(void);
static void test1_5(void);
static void test1_6(void);
static void test2_1(void);
static void test2_2(void);
static void test2_3(void);

int c_Sign()
{
	int n;

	printf("C_Sign\n");

	printf("  Cat 1\n");
	test1_3();

	initialize();

	session = getSessionInFirstSlot();

	test_cat1();
	test_cat2();
	
	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("C_Finalize didn't reutrn CKR_OK\n");
		return ++errors;
	}

	return errors;
}

static void test_cat1(void)
{
	/*printf("  \nCat 1\n");*/

	test1_1();
	test1_2();
	/* test1_3(); */ /* already done in c_Sign */
	test1_4();
	test1_5(); /* this disturbs all the following functions*/
	test1_6();
}

static void test_cat2(void)
{
	printf("  Cat 2\n");

	test2_1();
	test2_2();
	//test2_3();
}

/**************/
/* category 1 */
/**************/

static void test1_1(void)
{
	CK_BYTE_PTR pData = NULL;
	CK_ULONG ulDataLen = 0;
	CK_BYTE_PTR pSignature = NULL;
	CK_ULONG_PTR pulSignatureLen = NULL;
	CK_RV rv;

	//printf("\ntest 1.1\n");

	if (CKR_SESSION_HANDLE_INVALID != (rv = p11->C_Sign(12345, pData, ulDataLen, pSignature, pulSignatureLen))) {
		printf("    ERR: C_Sign didn't return CKR_SESSION_HANDLE_INVALID\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

static void test1_2(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 1.2\n");

	key = getprivkey1();
	
	if (CKR_OK != (rv = p11->C_SignInit(session, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_OK != rv) {
		printf("    ERR: C_Sign didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

/* test3: before C_Initialize */
static void test1_3(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;

	//printf("\ntest 1.3\n");

	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_CRYPTOKI_NOT_INITIALIZED != rv) {
		printf("    ERR: C_Sign didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

static void test1_4(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 1.4\n");

	key = getprivkey1();

	if (CKR_OPERATION_NOT_INITIALIZED != (rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen))) {
		printf("    ERR: C_Sign didn't return CKR_OPERATION_NOT_INITIALIZED\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}		
}

static void test1_5(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};
	CK_SESSION_HANDLE session2;

	//printf("\ntest 1.5\n");

	key = getprivkey1();

	session2 = getSessionInFirstSlot();

	if (CKR_OK != (rv = p11->C_SignInit(session2, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	if (CKR_OK != (rv = p11->C_CloseSession(session2))) {
		printf("C_CloseSession error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	if (CKR_SESSION_HANDLE_INVALID != (rv = p11->C_Sign(session2, data, sizeof(data), signature, &siglen))) {
		printf("    ERR: C_Sign didn't return CKR_SESSION_HANDLE_INVALID\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	session = getSessionInFirstSlot(); /* !! */
}

static void test1_6(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 1.6\n");

	key = getprivkey1();

	if (CKR_OK != (rv = p11->C_SignInit(session, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
	
	if (CKR_OK != (rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen))) {
		printf("    ERR: C_Sign didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	if (CKR_OPERATION_NOT_INITIALIZED != (rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen))) {
		printf("    ERR: second C_Sign didn't return CKR_OPERATION_NOT_INITIALIZED\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

/**************/
/* category 2 */
/**************/

static void test2_1(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 2.1\n");

	key = getprivkey1();
	
	if (CKR_OK != (rv = p11->C_SignInit(session, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	rv = p11->C_Sign(session, data, sizeof(data), NULL, &siglen);
	if (CKR_OK != rv) {
		printf("    ERR: C_Sign didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
	if (siglen != 128) { /* Stef is this correct ? */
		printf("    ERR: pulSignatureLen parameter != 128\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	/* this is necessary otherwise next Sign operation returns CKR_OPERATION_ACTIVE */

	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_OK != rv) {
		printf("    ERR: C_Sign didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

static void test2_2(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 10;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 2.2\n");

	key = getprivkey1();
	
	if (CKR_OK != (rv = p11->C_SignInit(session, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_BUFFER_TOO_SMALL != rv) {
		printf("    ERR: C_Sign didn't return CKR_BUFFER_TOO_SMALL\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}	
	
	/* this is necessary otherwise next Sign operation returns CKR_OPERATION_ACTIVE */

	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_OK != rv) {
		printf("    ERR: C_Sign didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
}

static void test2_3(void)
{
	CK_BYTE data[100];
	CK_BYTE signature[128];
	CK_ULONG siglen = 128;
	CK_RV rv;
	CK_OBJECT_HANDLE key = CK_INVALID_HANDLE;	
	CK_MECHANISM mechanism = {CKM_SHA1_RSA_PKCS, NULL_PTR, 0};

	//printf("\ntest 2.4\n");

	key = getprivkey1();
	
	if (CKR_OK != (rv = p11->C_SignInit(session, &mechanism, key))) {
		printf("C_SignInit error\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}

	rv = p11->C_SignUpdate(session, data, 16);
	if (CKR_OK != rv) {
		printf("    ERR: C_SignUpdate didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
	rv = p11->C_SignUpdate(session, data+16, 16);
	if (CKR_OK != rv) {
		printf("    ERR: C_SignUpdate didn't return CKR_OK\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}
	rv = p11->C_Sign(session, data, sizeof(data), signature, &siglen);
	if (CKR_OPERATION_ACTIVE != rv) {
		printf("    ERR: C_Sign didn't return CKR_OPERATION_ACTIVE\n");
		printf("return = %s\n", CKR2Str(rv));
		errors++;
		return;
	}	
}

/******************/
/* help functions */
/******************/

static void initialize(void)
{
	CK_RV rv;

	if ((rv = p11->C_Initialize(NULL_PTR) != CKR_OK)) {
		printf("    ERR: C_Initialize didn't return CKR_OK\n");
		printf("return = %s", CKR2Str(rv));
		++errors;
		return;
	}
}

/* fixme: hardcoded pin = 1234 ... */
static CK_OBJECT_HANDLE getprivkey1()
{
	static CK_OBJECT_HANDLE key;
	static firstTime = FALSE;
	static CK_RV rv;

	if (!firstTime) {
		if (CKR_OK != (rv = p11->C_Login(session, CKU_USER, "1234", 4))) {
			printf("C_Login failed\n");
			printf("return = %s", CKR2Str(rv));
			++errors;
			return 0;
		}
		key = find_object(session, CKO_PRIVATE_KEY, 0);
		firstTime = TRUE;
	}


	return key;
}

static void hexdump(const char *msg, const unsigned char *inp, int len)
{
	int i;
	printf("%s", msg);
	for (i = 0; i < len; i++)
		printf("%02X ", inp[i]);
	printf("(%d bytes)\n", len);
}