// AutoUpdate.h: interface for the CAutoUpdate class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AUTOUPDATE_H__1A24BC3C_0E79_4EA6_8C7A_F2FC5B476281__INCLUDED_)
#define AFX_AUTOUPDATE_H__1A24BC3C_0E79_4EA6_8C7A_F2FC5B476281__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "VersionInfo.h"

#include <wx/thread.h>

class CAutoUpdate : public wxThread  
{
public:
	CAutoUpdate(wxThreadKind kind = wxTHREAD_DETACHED);
	virtual ~CAutoUpdate();

    // Thread execution starts here
    virtual void *Entry();
    // Called when the thread exits - whether it terminates normally or is
    // stopped with Delete() (but not when it is Kill()ed!)
    virtual void OnExit();

    void RetrieveNewVersion (bool bNewCard = false);

protected:
    void ParseVersionFile (void *pszVersionFile, int iLen, CVersionInfo & oVersion);
    void ExecuteLink (const wxString &link); 

private:
    CVersionInfo m_oVersion;
    bool m_bAlreadyAsked;
    wxCriticalSection m_cs;
};

#endif // !defined(AFX_AUTOUPDATE_H__1A24BC3C_0E79_4EA6_8C7A_F2FC5B476281__INCLUDED_)
